/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.evomaster.client.java.sql.heuristic.ConversionHelper;
import org.evomaster.client.java.sql.internal.ColumnTypeParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ColumnTypeParserTest {
    @Test
    public void testValidInstantFormat() {
        String validInstant = "2025-01-22T14:30:00Z";
        Instant expected = Instant.parse(validInstant);
        Instant result = ColumnTypeParser.getAsInstant((String)validInstant);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the ISO 8601 formatted string correctly.");
    }

    @Test
    public void testValidZonedDateTimeFormat() {
        String zonedDateTime = "2025-01-22T14:30:00+00:00";
        Instant expected = ZonedDateTime.parse(zonedDateTime).toInstant();
        Instant result = ColumnTypeParser.getAsInstant((String)zonedDateTime);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the ZonedDateTime string correctly.");
    }

    @Test
    public void testValidOffsetDateTimeFormat() {
        String offsetDateTime = "2025-01-22 15:30:45+05:30";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
        Instant expected = OffsetDateTime.parse(offsetDateTime, formatter).toInstant();
        Instant result = ColumnTypeParser.getAsInstant((String)offsetDateTime);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the OffsetDateTime string correctly.");
    }

    @Test
    public void testValidCustomDateFormat() {
        String customDate = "22-Feb-25";
        Instant expected = LocalDate.parse(customDate, DateTimeFormatter.ofPattern("dd-MMM-yy")).atStartOfDay().toInstant(ZoneOffset.UTC);
        Instant result = ColumnTypeParser.getAsInstant((String)customDate);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the custom date format correctly.");
    }

    @Test
    public void testValidDateWithTime() throws ParseException {
        String dateWithTime = "2025-01-22 14:30:00.1234";
        Instant expected = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS").parse(dateWithTime).toInstant();
        Instant result = ColumnTypeParser.getAsInstant((String)dateWithTime);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the date with time format correctly.");
    }

    @Test
    public void testValidDateWithoutTime() throws ParseException {
        String dateWithoutTime = "2025-01-22";
        Instant expected = new SimpleDateFormat("yyyy-MM-dd").parse(dateWithoutTime).toInstant();
        Instant result = ColumnTypeParser.getAsInstant((String)dateWithoutTime);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Should parse the date without time correctly.");
    }

    @Test
    public void testInvalidDateFormat() throws ParseException {
        String invalidDate = "2025-13-01";
        Instant result = ColumnTypeParser.getAsInstant((String)invalidDate);
        Instant expectedInstant = new SimpleDateFormat("yyyy-MM-dd").parse("2026-01-01").toInstant();
        Assertions.assertEquals((Object)expectedInstant, (Object)result);
    }

    @Test
    public void testNullInput() {
        Assertions.assertThrows(NullPointerException.class, () -> ColumnTypeParser.getAsInstant(null));
    }

    @Test
    public void testInvalidDateTime() {
        String invalidDateTime = "invalid-date-time";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ColumnTypeParser.getAsInstant((String)invalidDateTime));
    }

    @Test
    public void testSameOutcome() {
        String timeAsString = "12:30:45";
        Time time = Time.valueOf(timeAsString);
        Instant instantFromTime = ConversionHelper.convertToInstant((Object)time);
        Instant instantFromString = ColumnTypeParser.getAsInstant((String)timeAsString);
        Assertions.assertEquals((Object)instantFromTime, (Object)instantFromString);
    }

    @Test
    public void testInvalidDateTimeWithEnclosingQuotes() {
        String dateWithTime = "'2025-01-22 15:30:45'";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ColumnTypeParser.getAsInstant((String)dateWithTime));
    }
}

