/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableIdDto;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import org.evomaster.client.java.sql.internal.TablesAndColumnsFinder;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class TablesAndColumnsFinderTest {
    TablesAndColumnsFinderTest() {
    }

    private static DbInfoDto createSchema() {
        DbInfoDto schema = new DbInfoDto();
        TableDto usersTable = new TableDto();
        usersTable.id = new TableIdDto();
        usersTable.id.name = "Users";
        usersTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("name", "Users"));
        usersTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("age", "Users"));
        TableDto employeesTable = new TableDto();
        employeesTable.id = new TableIdDto();
        employeesTable.id.name = "Employees";
        employeesTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("name", "Employees"));
        employeesTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("department_id", "Employees"));
        TableDto departmentsTable = new TableDto();
        departmentsTable.id = new TableIdDto();
        departmentsTable.id.name = "Departments";
        departmentsTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("id", "Departments"));
        departmentsTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("department_name", "Departments"));
        TableDto votingTable = new TableDto();
        votingTable.id = new TableIdDto();
        votingTable.id.name = "voting";
        votingTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("expired", "voting"));
        votingTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("created_at", "voting"));
        votingTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("group_id", "voting"));
        TableDto groupsTable = new TableDto();
        groupsTable.id = new TableIdDto();
        groupsTable.id.name = "groups";
        groupsTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("id", "groups"));
        groupsTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("voting_duration", "groups"));
        TableDto dbBaseTable = new TableDto();
        dbBaseTable.id = new TableIdDto();
        dbBaseTable.id.name = "db_base";
        dbBaseTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("id", "db_base"));
        dbBaseTable.columns.add(TablesAndColumnsFinderTest.createColumnDto("name", "db_base"));
        schema.tables.add(usersTable);
        schema.tables.add(employeesTable);
        schema.tables.add(departmentsTable);
        schema.tables.add(votingTable);
        schema.tables.add(groupsTable);
        schema.tables.add(dbBaseTable);
        return schema;
    }

    @NotNull
    private static ColumnDto createColumnDto(String columName, String tableName) {
        ColumnDto employeesNameColumn = new ColumnDto();
        employeesNameColumn.name = columName;
        employeesNameColumn.table = tableName;
        return employeesNameColumn;
    }

    @Test
    void findsTablesAndColumnsInSimpleSelectQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT name, age FROM Users WHERE age>18";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    private Set<String> createBooleanConstantNames() {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("true", "false")));
    }

    @Test
    void findsTablesAndColumnsInJoinQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT e.name, u.age FROM Employees e JOIN Users u ON e.name = u.name";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference employeesTableReference = new SqlBaseTableReference("Employees");
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(employeesTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employeesTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "name")));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
    }

    @Test
    void findsTablesAndColumnsInSubquery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT name FROM (SELECT name, age FROM Users WHERE age > 30) AS subquery";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesAndColumnsInUnionQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT name FROM Users UNION SELECT name FROM Employees";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        SqlBaseTableReference employeesTableReference = new SqlBaseTableReference("Employees");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(employeesTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employeesTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "name")));
    }

    @Test
    void handlesQueryWithoutTables() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT 1";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().isEmpty());
    }

    @Test
    void findsTablesAndColumnsInNestedSubqueries() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT name FROM (SELECT name FROM (SELECT name, age FROM Users WHERE age > 30) AS innerSubquery) AS outerSubquery";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesAndColumnsInUnionWithAliases() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT u.name FROM Users u UNION SELECT e.name FROM Employees e";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        SqlBaseTableReference employeesTableReference = new SqlBaseTableReference("Employees");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(employeesTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employeesTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "name")));
    }

    @Test
    void findsTablesAndColumnsInJoinWithSubqueries() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT e.name, u.age FROM (SELECT name FROM Employees) e JOIN (SELECT age FROM Users) u ON e.name = u.age";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference employeesTableReference = new SqlBaseTableReference("Employees");
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(employeesTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employeesTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "name")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesAndColumnsInComplexQueryWithMultipleJoinsAndSubqueries() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT e.name, d.department_name FROM (SELECT name, department_id FROM Employees) e JOIN (SELECT id, department_name FROM Departments) d ON e.department_id = d.id";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference employeesTableReference = new SqlBaseTableReference("Employees");
        SqlBaseTableReference departmentsTableReference = new SqlBaseTableReference("Departments");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(employeesTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(departmentsTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(employeesTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(employeesTableReference).contains(new SqlColumnReference((SqlTableReference)employeesTableReference, "department_id")));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(departmentsTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(departmentsTableReference).contains(new SqlColumnReference((SqlTableReference)departmentsTableReference, "id")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(departmentsTableReference).contains(new SqlColumnReference((SqlTableReference)departmentsTableReference, "department_name")));
    }

    @Test
    void findsTablesAndColumnsInCountQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT COUNT(*) AS n FROM Users f WHERE f.age > 18";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
    }

    @Test
    void testCountWithoutWhere() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT COUNT(f.age) AS n FROM Users f";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesAndColumnsInGroupByQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT COUNT(name), age FROM Users u GROUP BY age";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void testPatioApiIssue() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT v.* FROM voting v, groups g WHERE v.expired = false AND '2021-04-28T16:02:27.426+0200' >= v.created_at + g.voting_duration * INTERVAL '1 hour' AND v.group_id = g.id";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference votingTableReference = new SqlBaseTableReference("voting");
        SqlBaseTableReference groupsTableReference = new SqlBaseTableReference("groups");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(votingTableReference));
        Assertions.assertTrue((boolean)finder.containsColumnReferences(groupsTableReference));
        Assertions.assertEquals((int)3, (int)finder.getColumnReferences(votingTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(votingTableReference).contains(new SqlColumnReference((SqlTableReference)votingTableReference, "expired")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(votingTableReference).contains(new SqlColumnReference((SqlTableReference)votingTableReference, "created_at")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(votingTableReference).contains(new SqlColumnReference((SqlTableReference)votingTableReference, "group_id")));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(groupsTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(groupsTableReference).contains(new SqlColumnReference((SqlTableReference)groupsTableReference, "voting_duration")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(groupsTableReference).contains(new SqlColumnReference((SqlTableReference)groupsTableReference, "id")));
    }

    @Test
    void findsTablesAndColumnsInUpdateStatement() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "UPDATE Users SET age = 30 WHERE name = 'John'";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
    }

    @Test
    void findsTablesAndColumnsInDeleteStatement() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "DELETE FROM Users WHERE age > 18";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesInDelete() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "DELETE FROM Users";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(usersTableReference));
    }

    @Test
    void findsTablesAndColumnsInSelectAllQuery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT * FROM Users";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTablesAndColumnsInSelectAllFromDerivedTable() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT v.* FROM (SELECT name, age FROM Users WHERE age > 18) v";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsTwoColumns() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT * FROM Users WHERE name = 'joh' AND age IS NULL";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.containsColumnReferences(usersTableReference));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "name")));
    }

    @Test
    void findsDeleteJoinNoOnClause() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "DELETE FROM users JOIN departments WHERE age = 25";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        SqlBaseTableReference usersTableReference = new SqlBaseTableReference("Users");
        SqlBaseTableReference departmentsTableReference = new SqlBaseTableReference("Departments");
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(usersTableReference));
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(departmentsTableReference));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(usersTableReference).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(usersTableReference).contains(new SqlColumnReference((SqlTableReference)usersTableReference, "age")));
    }

    @Test
    void findsOuterColumnWithTable() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT * FROM employees WHERE EXISTS (SELECT id FROM departments WHERE employees.department_id = departments.id)";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        SqlBaseTableReference employees = new SqlBaseTableReference("employees");
        SqlBaseTableReference departments = new SqlBaseTableReference("departments");
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(employees));
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(departments));
        Assertions.assertEquals((int)2, (int)finder.getColumnReferences(employees).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employees).contains(new SqlColumnReference((SqlTableReference)employees, "name")));
        Assertions.assertTrue((boolean)finder.getColumnReferences(employees).contains(new SqlColumnReference((SqlTableReference)employees, "department_id")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(departments).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(departments).contains(new SqlColumnReference((SqlTableReference)departments, "id")));
    }

    @Test
    void findsOuterColumnWithAlias() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT 1 FROM employees e WHERE EXISTS (SELECT id FROM departments d WHERE e.department_id = d.id)";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        SqlBaseTableReference employees = new SqlBaseTableReference("employees");
        SqlBaseTableReference departments = new SqlBaseTableReference("departments");
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(employees));
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(departments));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employees).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employees).contains(new SqlColumnReference((SqlTableReference)employees, "department_id")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(departments).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(departments).contains(new SqlColumnReference((SqlTableReference)departments, "id")));
    }

    @Test
    void findsOuterColumn() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT 1 FROM employees WHERE EXISTS (SELECT id FROM departments WHERE department_id = id)";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)2, (int)finder.getBaseTableReferences().size());
        SqlBaseTableReference employees = new SqlBaseTableReference("employees");
        SqlBaseTableReference departments = new SqlBaseTableReference("departments");
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(employees));
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(departments));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(employees).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(employees).contains(new SqlColumnReference((SqlTableReference)employees, "department_id")));
        Assertions.assertEquals((int)1, (int)finder.getColumnReferences(departments).size());
        Assertions.assertTrue((boolean)finder.getColumnReferences(departments).contains(new SqlColumnReference((SqlTableReference)departments, "id")));
    }

    @Test
    void testInsertionWithUnicode() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "INSERT INTO db_base (id, name) VALUES (NULL, U & 'uow8J\\0080a88rKn4Y')";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(new SqlBaseTableReference("db_base")));
        Assertions.assertEquals((Object)false, (Object)finder.hasColumnReferences(new SqlBaseTableReference("db_base")));
    }

    @Test
    void testNullValue() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT NULL AS null_value FROM employees";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(new SqlBaseTableReference("employees")));
        Assertions.assertEquals((Object)false, (Object)finder.hasColumnReferences(new SqlBaseTableReference("employees")));
    }

    @Test
    void testNullValueInSubquery() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT null_value FROM (SELECT NULL AS null_value FROM employees)";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(new SqlBaseTableReference("employees")));
        Assertions.assertEquals((Object)false, (Object)finder.hasColumnReferences(new SqlBaseTableReference("employees")));
    }

    @Test
    void testLongValue() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT 42 AS non_null_value FROM employees";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)1, (int)finder.getBaseTableReferences().size());
        Assertions.assertTrue((boolean)finder.getBaseTableReferences().contains(new SqlBaseTableReference("employees")));
        Assertions.assertEquals((Object)false, (Object)finder.hasColumnReferences(new SqlBaseTableReference("employees")));
    }

    @Test
    void testNullValueInSubqueryNoFrom() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        String sql = "SELECT null_value FROM (SELECT NULL AS null_value)";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)0, (int)finder.getBaseTableReferences().size());
    }

    @Test
    void testMissingTables() throws JSQLParserException {
        DbInfoDto schema = TablesAndColumnsFinderTest.createSchema();
        Assumptions.assumeTrue((schema.tables.stream().filter(t -> t.id.name.equals("Foo")).count() == 0L ? 1 : 0) != 0);
        String sql = "SELECT * FROM Foo";
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(schema);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        statement.accept((StatementVisitor)finder);
        Assertions.assertEquals((int)0, (int)finder.getBaseTableReferences().size());
    }
}

