/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import org.evomaster.client.java.sql.SqlDataType;
import org.evomaster.client.java.sql.heuristic.BooleanLiteralsHelper;

public class SqlCastHelper {
    public static boolean castToBoolean(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (BooleanLiteralsHelper.isTrueLiteral(strValue).booleanValue()) {
                return BooleanLiteralsHelper.isTrueLiteral(strValue);
            }
            throw new IllegalArgumentException("Cannot cast to boolean: " + value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Cannot cast to boolean: " + value);
    }

    public static int castToInteger(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot cast to integer: " + value, e);
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IllegalArgumentException("Cannot cast to integer: " + value);
    }

    public static byte castToByte(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot cast to byte: " + value, e);
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (byte)1 : 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        throw new IllegalArgumentException("Cannot cast to byte: " + value);
    }

    public static short castToShort(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot cast to short: " + value, e);
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (short)1 : 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        throw new IllegalArgumentException("Cannot cast to short: " + value);
    }

    public static long castToLong(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot cast to long: " + value, e);
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Cannot cast to long: " + value);
    }

    public static double castToDouble(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot cast to double: " + value, e);
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("Cannot cast to double: " + value);
    }

    public static String castToString(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static Object castToDateTime(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof String) {
            return Timestamp.valueOf((String)value);
        }
        throw new IllegalArgumentException("Cannot cast to DateTime: " + value);
    }

    public static Object castTo(String dataTypeName, Object value) {
        Objects.requireNonNull(dataTypeName);
        SqlDataType dataType = SqlDataType.fromString(dataTypeName);
        return SqlCastHelper.castTo(dataType, value);
    }

    public static Object castTo(SqlDataType dataType, Object value) {
        Objects.requireNonNull(dataType);
        if (SqlDataType.isBooleanType(dataType)) {
            return SqlCastHelper.castToBoolean(value);
        }
        if (SqlDataType.isIntegerType(dataType)) {
            return SqlCastHelper.castToInteger(value);
        }
        if (SqlDataType.isByteType(dataType)) {
            return SqlCastHelper.castToByte(value);
        }
        if (SqlDataType.isShortType(dataType)) {
            return SqlCastHelper.castToShort(value);
        }
        if (SqlDataType.isLongType(dataType)) {
            return SqlCastHelper.castToLong(value);
        }
        if (SqlDataType.isDoubleType(dataType)) {
            return SqlCastHelper.castToDouble(value);
        }
        if (SqlDataType.isStringType(dataType)) {
            return SqlCastHelper.castToString(value);
        }
        if (SqlDataType.isDateTimeType(dataType)) {
            return SqlCastHelper.castToDateTime(value);
        }
        throw new IllegalArgumentException("Must implement casting to " + (Object)((Object)dataType) + ": " + value);
    }
}

