/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic.function;

import java.util.Map;
import java.util.TreeMap;
import org.evomaster.client.java.sql.heuristic.function.SqlAvgFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlCountFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlFunctionName;
import org.evomaster.client.java.sql.heuristic.function.SqlMaxFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlMinFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlSumFunction;
import org.evomaster.client.java.sql.heuristic.function.StringDecodeFunction;
import org.evomaster.client.java.sql.heuristic.function.TimeFunction;
import org.evomaster.client.java.sql.heuristic.function.UpperFunction;

public class FunctionFinder {
    private final Map<SqlFunctionName, SqlFunction> sqlFunctions = new TreeMap<SqlFunctionName, SqlFunction>();
    private static FunctionFinder instance = null;

    public void addFunction(SqlFunction sqlFunction) {
        if (this.sqlFunctions.containsKey(sqlFunction.getFunctionName())) {
            throw new IllegalArgumentException("Function " + sqlFunction.getFunctionName() + " already defined");
        }
        this.sqlFunctions.put(sqlFunction.getFunctionName(), sqlFunction);
    }

    public static FunctionFinder getInstance() {
        if (instance == null) {
            instance = new FunctionFinder();
        }
        return instance;
    }

    private FunctionFinder() {
        this.addFunction(new TimeFunction());
        this.addFunction(new UpperFunction());
        this.addFunction(new StringDecodeFunction());
        this.addFunction(new SqlCountFunction());
        this.addFunction(new SqlMaxFunction());
        this.addFunction(new SqlMinFunction());
        this.addFunction(new SqlSumFunction());
        this.addFunction(new SqlAvgFunction());
    }

    public SqlFunction getFunction(String functionName) {
        return this.sqlFunctions.get(new SqlFunctionName(functionName));
    }

    public boolean containsFunction(String functionName) {
        return this.sqlFunctions.containsKey(new SqlFunctionName(functionName));
    }
}

