/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic.function;

import java.math.BigDecimal;
import java.util.List;
import org.evomaster.client.java.sql.heuristic.function.SqlAggregateFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlAggregateFunctionUtils;

public class SqlAvgFunction
extends SqlAggregateFunction {
    private static final String AVG_FUNCTION_NAME = "AVG";

    public SqlAvgFunction() {
        super(AVG_FUNCTION_NAME);
    }

    @Override
    public Object evaluateValues(List<Object> values) {
        if (values.isEmpty()) {
            return null;
        }
        if (SqlAggregateFunctionUtils.allNullValues(values)) {
            return null;
        }
        if (SqlAggregateFunctionUtils.allFloats(values) || SqlAggregateFunctionUtils.allDoubles(values)) {
            double sum = SqlAggregateFunctionUtils.sumOfDoubleValues(values);
            double avg = sum / (double)SqlAggregateFunctionUtils.countNonNullValues(values);
            return avg;
        }
        if (SqlAggregateFunctionUtils.allBigDecimals(values)) {
            BigDecimal sum = SqlAggregateFunctionUtils.sumOfBigDecimals(values);
            BigDecimal avg = sum.divide(BigDecimal.valueOf(SqlAggregateFunctionUtils.countNonNullValues(values)));
            return avg;
        }
        long sum = SqlAggregateFunctionUtils.sumOfLongValues(values);
        long avg = sum / SqlAggregateFunctionUtils.countNonNullValues(values);
        return avg;
    }
}

