/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.sql.heuristic.BooleanLiteralsHelper;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;

public class TablesAndColumnsFinder
extends TablesNamesFinder {
    private final DbInfoDto schema;
    private final TableColumnResolver tableColumnResolver;
    private final Map<SqlBaseTableReference, Set<SqlColumnReference>> columnReferences = new LinkedHashMap<SqlBaseTableReference, Set<SqlColumnReference>>();
    private final Set<SqlBaseTableReference> baseTableReferences = new LinkedHashSet<SqlBaseTableReference>();
    private final Set<String> otherItemNames = new HashSet<String>();

    public TablesAndColumnsFinder(DbInfoDto schema) {
        this.tableColumnResolver = new TableColumnResolver(schema);
        this.schema = schema;
        this.init(true);
    }

    public void visit(PlainSelect plainSelect) {
        this.tableColumnResolver.enterStatementeContext((Statement)plainSelect);
        super.visit(plainSelect);
        this.tableColumnResolver.exitCurrentStatementContext();
    }

    public void visit(Update update) {
        this.tableColumnResolver.enterStatementeContext((Statement)update);
        super.visit(update);
        for (UpdateSet updateSet : update.getUpdateSets()) {
            updateSet.getColumns().accept((ExpressionVisitor)this);
            updateSet.getValues().accept((ExpressionVisitor)this);
        }
        this.tableColumnResolver.exitCurrentStatementContext();
    }

    public void visit(Delete delete) {
        this.tableColumnResolver.enterStatementeContext((Statement)delete);
        super.visit(delete);
        this.tableColumnResolver.exitCurrentStatementContext();
    }

    public Set<SqlBaseTableReference> getBaseTableReferences() {
        return this.baseTableReferences;
    }

    public Set<SqlColumnReference> getColumnReferences(SqlBaseTableReference baseTableReference) {
        Objects.requireNonNull(baseTableReference);
        if (!this.columnReferences.containsKey(baseTableReference)) {
            throw new IllegalStateException("No column references found for table: " + baseTableReference);
        }
        return this.columnReferences.get(baseTableReference);
    }

    public boolean hasColumnReferences(SqlBaseTableReference baseTableReference) {
        Objects.requireNonNull(baseTableReference);
        return this.columnReferences.containsKey(baseTableReference);
    }

    public void visit(Column tableColumn) {
        super.visit(tableColumn);
        if (BooleanLiteralsHelper.isBooleanLiteral(tableColumn.getColumnName()).booleanValue()) {
            return;
        }
        SqlColumnReference columnReference = this.tableColumnResolver.resolve(tableColumn);
        if (columnReference == null) {
            return;
        }
        if (columnReference.getTableReference() instanceof SqlBaseTableReference) {
            SqlBaseTableReference baseTableReference = (SqlBaseTableReference)columnReference.getTableReference();
            this.addColumnReference(baseTableReference, columnReference);
        }
    }

    private void addColumnReference(SqlBaseTableReference baseTableReference, SqlColumnReference columnReference) {
        Set sqlColumnReferencesSet = this.columnReferences.computeIfAbsent(baseTableReference, k -> new LinkedHashSet());
        sqlColumnReferencesSet.add(columnReference);
        this.baseTableReferences.add(baseTableReference);
    }

    public void visit(AllColumns allColumns) {
        Statement statement = this.tableColumnResolver.getCurrentStatement();
        Set<SqlColumnReference> selectedColumns = this.findColumnReferences((Select)statement);
        for (SqlColumnReference columnReference : selectedColumns) {
            if (columnReference.getTableReference() instanceof SqlBaseTableReference) {
                SqlBaseTableReference baseTableReference = (SqlBaseTableReference)columnReference.getTableReference();
                this.addColumnReference(baseTableReference, columnReference);
                continue;
            }
            if (columnReference.getTableReference() instanceof SqlDerivedTableReference) continue;
            throw new IllegalStateException("Unexpected table reference type: " + columnReference.getTableReference().getClass().getName());
        }
        super.visit(allColumns);
    }

    public void visit(AllTableColumns allTableColumns) {
        super.visit(allTableColumns);
        SqlTableReference tableReference = this.tableColumnResolver.resolve(allTableColumns.getTable());
        if (!(tableReference instanceof SqlDerivedTableReference)) {
            if (tableReference instanceof SqlBaseTableReference) {
                SqlBaseTableReference baseTableReference = (SqlBaseTableReference)tableReference;
                this.schema.tables.stream().filter(t -> new SqlTableId(t.id.name).equals(baseTableReference.getTableId())).flatMap(t -> t.columns.stream()).map(c -> new SqlColumnReference(baseTableReference, c.name)).forEach(c -> this.addColumnReference(baseTableReference, (SqlColumnReference)c));
            } else {
                throw new IllegalStateException("Unexpected table reference type: " + tableReference.getClass().getName());
            }
        }
    }

    public void visit(Table tableName) {
        SqlTableReference tableReference;
        super.visit(tableName);
        String tableWholeName = this.extractTableName(tableName);
        if (!this.otherItemNames.contains(tableWholeName.toLowerCase()) && (tableReference = this.tableColumnResolver.resolve(tableName)) instanceof SqlBaseTableReference) {
            SqlBaseTableReference baseTableReference = (SqlBaseTableReference)tableReference;
            this.baseTableReferences.add(baseTableReference);
        }
    }

    public void visit(WithItem withItem) {
        this.otherItemNames.add(withItem.getAlias().getName().toLowerCase());
        super.visit(withItem);
    }

    public boolean containsColumnReferences(SqlBaseTableReference baseTableReference) {
        return this.columnReferences.containsKey(baseTableReference);
    }

    private Set<SqlColumnReference> findColumnReferences(SqlTableId baseTableId) {
        Objects.requireNonNull(baseTableId);
        return this.schema.tables.stream().filter(t -> new SqlTableId(t.id.name).equals(baseTableId)).flatMap(t -> t.columns.stream()).map(c -> new SqlColumnReference(new SqlBaseTableReference(c.table), c.name)).collect(Collectors.toSet());
    }

    private Set<SqlColumnReference> findColumnReferences(FromItem fromItem) {
        if (fromItem instanceof LateralSubSelect) {
            LateralSubSelect lateralSubSelect = (LateralSubSelect)fromItem;
            Select subquery = lateralSubSelect.getSelect();
            return this.findColumnReferences(subquery);
        }
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            SqlTableReference tableReference = this.tableColumnResolver.resolve(table);
            if (tableReference != null) {
                if (tableReference instanceof SqlBaseTableReference) {
                    SqlBaseTableReference sqlBaseTableReference = (SqlBaseTableReference)tableReference;
                    return this.findColumnReferences(sqlBaseTableReference.getTableId());
                }
                if (tableReference instanceof SqlDerivedTableReference) {
                    SqlDerivedTableReference sqlDerivedTableReference = (SqlDerivedTableReference)tableReference;
                    return this.findColumnReferences(sqlDerivedTableReference.getSelect());
                }
                throw new IllegalArgumentException("Cannot handle reference of class " + tableReference.getClass().getName());
            }
            return Collections.emptySet();
        }
        if (fromItem instanceof ParenthesedFromItem) {
            ParenthesedFromItem parenthesedFromItem = (ParenthesedFromItem)fromItem;
            return this.findColumnReferences(parenthesedFromItem.getFromItem());
        }
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            Select subquery = parenthesedSelect.getSelect();
            return this.findColumnReferences(subquery);
        }
        if (fromItem instanceof TableFunction) {
            TableFunction tableFunction = (TableFunction)fromItem;
            throw new UnsupportedOperationException("Implement handling of table functions" + tableFunction);
        }
        throw new IllegalArgumentException("Unsupported from item type: " + fromItem.getClass());
    }

    private Set<SqlColumnReference> findColumnReferences(Select select) {
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            List<FromItem> fromItemList = SqlParserUtils.getFromAndJoinItems((Select)plainSelect);
            LinkedHashSet<SqlColumnReference> columns = new LinkedHashSet<SqlColumnReference>();
            for (FromItem fromItem : fromItemList) {
                Set<SqlColumnReference> fromItemColumns = this.findColumnReferences(fromItem);
                columns.addAll(fromItemColumns);
            }
            return columns;
        }
        if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            LinkedHashSet<SqlColumnReference> columns = new LinkedHashSet<SqlColumnReference>();
            for (Select subquery : setOperationList.getSelects()) {
                Set<SqlColumnReference> subqueryColumns = this.findColumnReferences(subquery);
                columns.addAll(subqueryColumns);
            }
            return columns;
        }
        if (select instanceof WithItem) {
            WithItem withItem = (WithItem)select;
            Select subquery = withItem.getSelect();
            return this.findColumnReferences(subquery);
        }
        if (select instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)select;
            Select subquery = parenthesedSelect.getSelect();
            return this.findColumnReferences(subquery);
        }
        throw new IllegalArgumentException("Unsupported select type: " + select.getClass());
    }
}

