/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal.constraint;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.internal.constraint.DbTableCheckExpression;
import org.evomaster.client.java.sql.internal.constraint.DbTableConstraint;
import org.evomaster.client.java.sql.internal.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.sql.internal.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class MySQLConstraintExtractor
extends TableConstraintExtractor {
    private static final String MYSQL_CONSTRAINT_TYPE_CHECK = "CHECK";
    private static final String MYSQL_CONSTRAINT_TYPE_FOREIGN_KEY = "FOREIGN KEY";
    private static final String MYSQL_CONSTRAINT_TYPE_PRIMARY_KEY = "PRIMARY KEY";
    private static final String MYSQL_CONSTRAINT_TYPE_UNIQUE = "UNIQUE";
    private static final String MYSQL_CONSTRAINT_NAME = "CONSTRAINT_NAME";
    private static final String MYSQL_CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    private static final String MYSQL_CHECK_CLAUSE = "CHECK_CLAUSE";
    private static final String MYSQL_COLUMN_NAME = "COLUMN_NAME";
    private static final String MYSQL_ENUM_COLUMN_TYPE = "COLUMN_TYPE";

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn((String)("WARNING, EvoMaster cannot extract MySQL constraints with type '" + constraintType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DbTableConstraint> extract(Connection connectionToMySQL, DbInfoDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> constraints = new ArrayList<DbTableConstraint>();
        Iterator iterator = schemaDto.tables.iterator();
        block21: while (iterator.hasNext()) {
            TableDto tableDto = (TableDto)iterator.next();
            String tableSchema = tableDto.id.schema;
            String tableName = tableDto.id.name;
            try (Statement statement = connectionToMySQL.createStatement();){
                String query = String.format("SELECT *\n       FROM information_schema.table_constraints\n       WHERE table_schema = '%s'\n             AND table_name = '%s';", tableSchema, tableName);
                try (ResultSet columns = statement.executeQuery(query);){
                    block22: while (columns.next()) {
                        String type;
                        switch (type = columns.getString(MYSQL_CONSTRAINT_TYPE)) {
                            case "PRIMARY KEY": 
                            case "FOREIGN KEY": {
                                continue block22;
                            }
                            case "CHECK": {
                                String constraintName = columns.getString(MYSQL_CONSTRAINT_NAME);
                                DbTableCheckExpression check = this.getCheckConstraint(connectionToMySQL, tableName, constraintName);
                                constraints.add(check);
                                continue block22;
                            }
                            case "UNIQUE": {
                                String uniqueConstraintName = columns.getString(MYSQL_CONSTRAINT_NAME);
                                DbTableUniqueConstraint uniqueConstraint = this.getUniqueConstraint(connectionToMySQL, tableSchema, tableName, uniqueConstraintName);
                                constraints.add(uniqueConstraint);
                                continue block22;
                            }
                        }
                        MySQLConstraintExtractor.cannotHandle("Unknown constraint type " + type);
                    }
                }
            }
            Iterator iterator2 = tableDto.columns.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block21;
                ColumnDto column = (ColumnDto)iterator2.next();
                if (!column.type.equalsIgnoreCase("enum")) continue;
                DbTableCheckExpression enumConstraint = this.handleEnum(connectionToMySQL, tableSchema, tableName, column.name);
                constraints.add(enumConstraint);
            }
            break;
        }
        return constraints;
    }

    private DbTableUniqueConstraint getUniqueConstraint(Connection connectionToMySQL, String tableSchema, String tableName, String constraintName) throws SQLException {
        String query = String.format("SELECT %s \n   FROM information_schema.KEY_COLUMN_USAGE\n   WHERE TABLE_SCHEMA = '%s'\n       AND TABLE_NAME = '%s'\n       AND CONSTRAINT_NAME='%s';\n", MYSQL_COLUMN_NAME, tableSchema, tableName, constraintName);
        try (Statement stmt = connectionToMySQL.createStatement();){
            DbTableUniqueConstraint dbTableUniqueConstraint;
            block14: {
                ResultSet columns = stmt.executeQuery(query);
                try {
                    ArrayList<String> uniqueColumnNames = new ArrayList<String>();
                    while (columns.next()) {
                        uniqueColumnNames.add(columns.getString(MYSQL_COLUMN_NAME));
                    }
                    if (uniqueColumnNames.isEmpty()) {
                        throw new IllegalStateException("Unexpected missing column names");
                    }
                    dbTableUniqueConstraint = new DbTableUniqueConstraint(tableName, uniqueColumnNames);
                    if (columns == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columns != null) {
                        try {
                            columns.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columns.close();
            }
            return dbTableUniqueConstraint;
        }
    }

    private DbTableCheckExpression getCheckConstraint(Connection connectionToMySQL, String tableName, String constraintName) throws SQLException {
        String query = String.format("SELECT %s \nFROM information_schema.CHECK_CONSTRAINTS\nWHERE CONSTRAINT_NAME='%s';\n", MYSQL_CHECK_CLAUSE, constraintName);
        try (Statement stmt = connectionToMySQL.createStatement();){
            DbTableCheckExpression dbTableCheckExpression;
            block13: {
                ResultSet check = stmt.executeQuery(query);
                try {
                    boolean hasChecks = check.next();
                    if (!hasChecks) {
                        throw new IllegalStateException("Unexpected missing check scripts");
                    }
                    String check_clause = this.postCheckConstraintHandling(check.getString(MYSQL_CHECK_CLAUSE));
                    dbTableCheckExpression = new DbTableCheckExpression(tableName, check_clause);
                    if (check == null) break block13;
                }
                catch (Throwable throwable) {
                    if (check != null) {
                        try {
                            check.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                check.close();
            }
            return dbTableCheckExpression;
        }
    }

    private String postCheckConstraintHandling(String check_exp) {
        return check_exp.replaceAll("`", "").replaceAll("_utf8mb4", "").replaceAll("\\\\'", "'");
    }

    private DbTableCheckExpression handleEnum(Connection connectionToMySQL, String schemaName, String tableName, String columnName) throws SQLException {
        String query = String.format("SELECT %s\n       FROM information_schema.COLUMNS\n       WHERE TABLE_SCHEMA='%s'\n           AND TABLE_NAME='%s'\n           AND COLUMN_NAME='%s';", MYSQL_ENUM_COLUMN_TYPE, schemaName, tableName, columnName);
        try (Statement stmt = connectionToMySQL.createStatement();){
            DbTableCheckExpression dbTableCheckExpression;
            block13: {
                ResultSet literals = stmt.executeQuery(query);
                try {
                    boolean hasLiterals = literals.next();
                    if (!hasLiterals) {
                        throw new IllegalStateException("Unexpected missing literals of enum");
                    }
                    String literalsValue = literals.getString(MYSQL_ENUM_COLUMN_TYPE);
                    dbTableCheckExpression = new DbTableCheckExpression(tableName, String.format("%s %s", columnName, literalsValue));
                    if (literals == null) break block13;
                }
                catch (Throwable throwable) {
                    if (literals != null) {
                        try {
                            literals.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                literals.close();
            }
            return dbTableCheckExpression;
        }
    }
}

