/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.sql.Timestamp;
import java.util.Date;
import org.evomaster.client.java.sql.heuristic.SqlCastHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SqlCastHelperTest {
    SqlCastHelperTest() {
    }

    @Test
    public void testCastToBooleanWithInteger() {
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)1));
        Assertions.assertFalse((boolean)SqlCastHelper.castToBoolean((Object)0));
    }

    @Test
    public void testCastToBooleanWithString() {
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"true"));
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"yes"));
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"on"));
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"t"));
    }

    @Test
    public void testCastToBooleanWithBoolean() {
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)true));
        Assertions.assertFalse((boolean)SqlCastHelper.castToBoolean((Object)false));
    }

    @Test
    public void testCastToBooleanWithNull() {
        Assertions.assertThrows(NullPointerException.class, () -> SqlCastHelper.castToBoolean(null));
    }

    @Test
    public void testCastToBooleanWithInvalidString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)"invalid"));
    }

    @Test
    public void testCastToBooleanWithEmptyString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)""));
    }

    @Test
    public void testCastToBooleanWithNonIntegerNumber() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)2.5));
    }

    @Test
    public void testCastToBooleanWithNonStringObject() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)new Object()));
    }

    @Test
    public void testCastToBooleanWithUppercaseTrueAndYes() {
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"TRUE"));
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)"YES"));
    }

    @Test
    public void testCastToBooleanWithNegativeInteger() {
        Assertions.assertTrue((boolean)SqlCastHelper.castToBoolean((Object)-1));
    }

    @Test
    public void testCastToBooleanWithInvalidType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)1.5));
    }

    @Test
    public void testCastToBooleanWithFalseLiteral() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)"false"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)"no"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)"off"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castToBoolean((Object)"f"));
    }

    @Test
    public void testCastToBoolean() {
        Assertions.assertTrue((boolean)((Boolean)SqlCastHelper.castTo((String)"BOOLEAN", (Object)1)));
        Assertions.assertFalse((boolean)((Boolean)SqlCastHelper.castTo((String)"BOOLEAN", (Object)0)));
        Assertions.assertTrue((boolean)((Boolean)SqlCastHelper.castTo((String)"BOOLEAN", (Object)"true")));
    }

    @Test
    public void testCastToInteger() {
        Assertions.assertEquals((Object)42, (Object)SqlCastHelper.castTo((String)"INTEGER", (Object)42));
        Assertions.assertEquals((Object)42, (Object)SqlCastHelper.castTo((String)"INTEGER", (Object)"42"));
        Assertions.assertEquals((Object)0, (Object)SqlCastHelper.castTo((String)"INTEGER", (Object)false));
    }

    @Test
    public void testCastToByte() {
        Assertions.assertEquals((Object)10, (Object)SqlCastHelper.castTo((String)"TINYINT", (Object)10));
        Assertions.assertEquals((Object)10, (Object)SqlCastHelper.castTo((String)"TINYINT", (Object)"10"));
        Assertions.assertEquals((Object)1, (Object)SqlCastHelper.castTo((String)"TINYINT", (Object)true));
    }

    @Test
    public void testCastToShort() {
        Assertions.assertEquals((Object)123, (Object)SqlCastHelper.castTo((String)"SMALLINT", (Object)123));
        Assertions.assertEquals((Object)123, (Object)SqlCastHelper.castTo((String)"SMALLINT", (Object)"123"));
        Assertions.assertEquals((Object)0, (Object)SqlCastHelper.castTo((String)"SMALLINT", (Object)false));
    }

    @Test
    public void testCastToLong() {
        Assertions.assertEquals((Object)9876543210L, (Object)SqlCastHelper.castTo((String)"BIGINT", (Object)9876543210L));
        Assertions.assertEquals((Object)9876543210L, (Object)SqlCastHelper.castTo((String)"BIGINT", (Object)"9876543210"));
        Assertions.assertEquals((Object)0L, (Object)SqlCastHelper.castTo((String)"BIGINT", (Object)false));
    }

    @Test
    public void testCastToDouble() {
        Assertions.assertEquals((Object)123.45, (Object)SqlCastHelper.castTo((String)"DOUBLE", (Object)123.45));
        Assertions.assertEquals((Object)123.45, (Object)SqlCastHelper.castTo((String)"DOUBLE", (Object)"123.45"));
        Assertions.assertEquals((Object)1.0, (Object)SqlCastHelper.castTo((String)"DOUBLE", (Object)true));
    }

    @Test
    public void testCastToString() {
        Assertions.assertEquals((Object)"hello", (Object)SqlCastHelper.castTo((String)"VARCHAR", (Object)"hello"));
        Assertions.assertEquals((Object)"42", (Object)SqlCastHelper.castTo((String)"VARCHAR", (Object)42));
        Assertions.assertEquals((Object)"true", (Object)SqlCastHelper.castTo((String)"VARCHAR", (Object)true));
    }

    @Test
    public void testCastToDateTime() {
        Assertions.assertEquals((Object)Timestamp.valueOf("2023-01-01 12:00:00"), (Object)SqlCastHelper.castTo((String)"DATETIME", (Object)"2023-01-01 12:00:00"));
        Assertions.assertEquals((Object)new Date(0L), (Object)SqlCastHelper.castTo((String)"DATETIME", (Object)new Date(0L)));
    }

    @Test
    public void testCastToInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castTo((String)"BOOLEAN", (Object)"not_a_boolean"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castTo((String)"INTEGER", (Object)"not_an_integer"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SqlCastHelper.castTo((String)"DATETIME", (Object)12345));
    }

    @Test
    public void castToInteger() {
        Integer actual = SqlCastHelper.castToInteger((Object)1.0);
        Assertions.assertEquals((int)1, (int)actual);
    }
}

