/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import org.evomaster.client.java.sql.internal.SelectTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SelectTransformerTest {
    @Test
    public void testCount() {
        String select = "select count(*) as n from Foo f where f.id=1";
        String withFields = SelectTransformer.addFieldsToSelect((String)select);
        String withoutConstraints = SelectTransformer.removeConstraints((String)withFields);
        String withoutOperations = SelectTransformer.removeOperations((String)withoutConstraints);
        Assertions.assertFalse((boolean)withoutOperations.contains("where"));
        Assertions.assertTrue((boolean)withoutOperations.contains("id"));
        Assertions.assertFalse((boolean)withoutOperations.contains("count"));
    }

    @Test
    public void testCountWithoutWhere() {
        String select = "select count(c.id) from categories c";
        String withFields = SelectTransformer.addFieldsToSelect((String)select);
        String withoutConstraints = SelectTransformer.removeConstraints((String)withFields);
        String withoutOperations = SelectTransformer.removeOperations((String)withoutConstraints);
        Assertions.assertFalse((boolean)withoutOperations.contains("where"));
        Assertions.assertTrue((boolean)withoutOperations.contains("*"));
        Assertions.assertFalse((boolean)withoutOperations.contains("count"));
    }

    @Test
    public void testGroupBy() {
        String select = "select count(x), y from Foo f group by y";
        String withFields = SelectTransformer.addFieldsToSelect((String)select);
        String withoutConstraints = SelectTransformer.removeConstraints((String)withFields);
        String withoutOperations = SelectTransformer.removeOperations((String)withoutConstraints);
        Assertions.assertFalse((boolean)withoutOperations.contains("where"));
        Assertions.assertTrue((boolean)withoutOperations.contains("y"));
        Assertions.assertFalse((boolean)withoutOperations.contains("count"));
        Assertions.assertFalse((boolean)withoutOperations.contains("group"));
    }

    @Test
    public void testAddFields() {
        String select = "select f.x from Foo f where f.y=5";
        String enh = SelectTransformer.addFieldsToSelect((String)select);
        String res = SelectTransformer.removeConstraints((String)enh);
        Assertions.assertTrue((boolean)res.toLowerCase().contains("f.x"));
        Assertions.assertTrue((boolean)res.toLowerCase().contains("f.y"));
        Assertions.assertFalse((boolean)res.toLowerCase().contains("where"));
    }

    @Test
    public void testRemoveWhenUnion() {
        int x = 15;
        int y = 72;
        String select = "select x from Foo where x=" + x + " UNION ALL select z from Bar where y=" + y;
        String res = SelectTransformer.removeConstraints((String)select).toLowerCase();
        Assertions.assertTrue((boolean)res.contains("foo"));
        Assertions.assertTrue((boolean)res.contains("bar"));
        Assertions.assertTrue((boolean)res.contains("union"));
        Assertions.assertTrue((boolean)res.contains("all"));
        Assertions.assertFalse((boolean)res.contains("" + x));
        Assertions.assertFalse((boolean)res.contains("" + y));
    }

    @Test
    public void testRemoveNested() {
        String select = "select t.x, t.y from (select z as x, 1 as y from Foo where z<10) t where x>3";
        String res = SelectTransformer.removeConstraints((String)select.toLowerCase());
        Assertions.assertTrue((boolean)res.contains("foo"));
        Assertions.assertTrue((boolean)res.contains("x"));
        Assertions.assertTrue((boolean)res.contains("y"));
        Assertions.assertTrue((boolean)res.contains("z"));
        Assertions.assertFalse((boolean)res.contains("3"));
        Assertions.assertTrue((boolean)res.contains("10"));
    }

    @Test
    public void testRemoveInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SelectTransformer.removeConstraints((String)"select * from"));
    }

    private void assertEquivalent(String a, String b) {
        if (a == null && b == null) {
            return;
        }
        Assertions.assertEquals((Object)a.trim().toLowerCase(), (Object)b.trim().toLowerCase());
    }

    @Test
    public void testRemoveSame() {
        String sql = "select * from Foo";
        String res = SelectTransformer.removeConstraints((String)sql);
        this.assertEquivalent(sql, res);
    }

    @Test
    public void testRemoveWhere() {
        String base = "select a from Foo ";
        String sql = base + " where a=5";
        String res = SelectTransformer.removeConstraints((String)sql);
        this.assertEquivalent(base, res);
    }

    @Test
    public void testRemoveWithLimit() {
        String base = "select a from Foo ";
        String sql = base + " where a=5 limit 1";
        String res = SelectTransformer.removeConstraints((String)sql);
        this.assertEquivalent(base, res);
    }

    @Test
    public void testAddLimitForRowCount() {
        String base = "select a from Foo";
        String originalLimit = " limit 1";
        String where = " where a = 5";
        String sql = base + where + originalLimit;
        int limit = 5;
        String addedLimit = " limit " + limit;
        String res0 = SelectTransformer.addLimitForHandlingRowCount((String)sql, (boolean)true, (int)limit);
        this.assertEquivalent(base + addedLimit, res0);
        String res1 = SelectTransformer.addLimitForHandlingRowCount((String)sql, (boolean)false, (int)limit);
        this.assertEquivalent(base + where + addedLimit, res1);
    }

    @Test
    public void testRemoveWhere_aliases() {
        String base = "select t.a as x, t.b as y from Foo t";
        String sql = base + " where x=5 and y=8";
        String res = SelectTransformer.removeConstraints((String)sql);
        this.assertEquivalent(base, res);
    }

    @Test
    public void testPatioApiIssue() {
        String select = "SELECT v.* FROM voting v, groups g WHERE v.expired = false AND '2021-04-28T16:02:27.426+0200' >= v.created_at + g.voting_duration * INTERVAL '1 hour' AND v.group_id = g.id";
        String res = SelectTransformer.addFieldsToSelect((String)select);
    }
}

