/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.utils;

import java.util.HashSet;
import java.util.Set;

public class SimpleLogger {
    public static final String PROP_LOGGER_LEVEL = "em.logger.level";
    private static Level threshold = Level.INFO;
    private static final Set<String> uniqueMessages = new HashSet<String>(1024);

    public static Level getThreshold() {
        return threshold;
    }

    public static void setThreshold(Level threshold) {
        SimpleLogger.threshold = threshold;
    }

    public static void updateThreshold() {
        String level = System.getProperty(PROP_LOGGER_LEVEL);
        if (level != null) {
            SimpleLogger.setThreshold(Level.valueOf(level));
        }
    }

    public static void debug(String message) {
        SimpleLogger.printMessage(Level.DEBUG, message, null);
    }

    public static void info(String message) {
        SimpleLogger.printMessage(Level.INFO, message, null);
    }

    public static void uniqueWarn(String message) {
        if (uniqueMessages.contains(message)) {
            return;
        }
        uniqueMessages.add(message);
        SimpleLogger.warn(message);
    }

    public static void warn(String message) {
        SimpleLogger.warn(message, null);
    }

    public static void warn(String message, Throwable t) {
        SimpleLogger.printMessage(Level.WARN, message, t);
    }

    public static void error(String message) {
        SimpleLogger.error(message, null);
    }

    public static void error(String message, Throwable t) {
        SimpleLogger.printMessage(Level.ERROR, message, t);
    }

    private static void printMessage(Level level, String message, Throwable t) {
        if (level.compareTo(threshold) >= 0) {
            if (level.equals((Object)Level.WARN) || level.equals((Object)Level.ERROR)) {
                System.out.print("" + (Object)((Object)level) + " - ");
            }
            System.out.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

