/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.test.utils;

import org.evomaster.test.utils.EMTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EMTestUtilsTest {
    @Test
    public void testResolveLocation_direct() {
        String template = "http://localhost:12345/a/{id}";
        String location = "/a/5";
        String res = EMTestUtils.resolveLocation((String)location, (String)template);
        Assertions.assertEquals((Object)"http://localhost:12345/a/5", (Object)res);
    }

    @Test
    public void testResolveLocation_indirect() {
        String template = "http://localhost:12345/a/{id}/x";
        String location = "/a/5";
        String res = EMTestUtils.resolveLocation((String)location, (String)template);
        Assertions.assertEquals((Object)"http://localhost:12345/a/5/x", (Object)res);
    }

    @Test
    public void testResolveLocation_fullURI_different_indirect() {
        String template = "http://localhost:12345/a/{id}/x";
        String location = "https://127.0.0.1:80/a/5";
        String res = EMTestUtils.resolveLocation((String)location, (String)template);
        Assertions.assertEquals((Object)"https://127.0.0.1:80/a/5/x", (Object)res);
    }

    @Test
    public void testResolveLocation_null() {
        String template = "http://localhost:12345/a/x";
        String location = null;
        String res = EMTestUtils.resolveLocation(location, (String)template);
        Assertions.assertEquals((Object)template, (Object)res);
    }

    @Test
    public void testGivenAnInvalidLocationHeaderWhenResolveLocationThenTheExpectedTemplateIsReturned() {
        String expectedTemplate = "http://localhost:12345/a/x";
        String locationHeader = "/a/\"52\"";
        String resolvedLocation = EMTestUtils.resolveLocation((String)locationHeader, (String)expectedTemplate);
        Assertions.assertEquals((Object)locationHeader, (Object)resolvedLocation);
    }

    @Test
    public void testIsValidURI() {
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty(null));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"    "));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"a"));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"/a"));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"/a/b"));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"/a/b/c?k=4&z=foo"));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"http://foo.org/a"));
        Assertions.assertTrue((boolean)EMTestUtils.isValidURIorEmpty((String)"https://127.0.0.1:443"));
        Assertions.assertFalse((boolean)EMTestUtils.isValidURIorEmpty((String)"/{a}"));
    }
}

