/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.control.parallel.Callables;
import fj.data.Array;
import fj.data.Java;
import fj.data.List;
import fj.function.Effect1;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class Strategy<A> {
    private final F<P1<A>, P1<A>> f;

    private Strategy(F<P1<A>, P1<A>> f) {
        this.f = f;
    }

    public F<P1<A>, P1<A>> f() {
        return this.f;
    }

    public static <A> Strategy<A> strategy(F<P1<A>, P1<A>> f) {
        return new Strategy<A>(f);
    }

    public P1<A> par(P1<A> a) {
        return this.f().f(a);
    }

    public <B> F<B, P1<A>> concurry(F<B, A> f) {
        return Function.compose(this.f(), P1.curry(f));
    }

    public <B, C> F<B, F<C, P1<A>>> concurry(F2<B, C, A> f) {
        return b -> this.concurry(Function.curry(f).f(b));
    }

    public static <A> List<P1<A>> mergeAll(List<Future<A>> xs) {
        return xs.map(Strategy.obtain());
    }

    public P1<List<A>> parList(List<P1<A>> ps) {
        return P1.sequence(ps.map(this.f()));
    }

    public <B> P1<List<A>> parMap(F<B, A> f, List<B> bs) {
        return P1.sequence(bs.map(this.concurry(f)));
    }

    public <B> P1<Array<A>> parMap(F<B, A> f, Array<B> bs) {
        return P1.sequence(bs.map(this.concurry(f)));
    }

    public <B> List<A> parMap1(F<B, A> f, List<B> bs) {
        return (List)Function.compose(P1.__1(), this.parMapList(f)).f(bs);
    }

    public <B> Array<A> parMap1(F<B, A> f, Array<B> bs) {
        return (Array)Function.compose(P1.__1(), this.parMapArray(f)).f(bs);
    }

    public <B> F<List<B>, P1<List<A>>> parMapList(F<B, A> f) {
        return as -> this.parMap(f, (List)as);
    }

    public <B> F<F<B, A>, F<List<B>, P1<List<A>>>> parMapList() {
        return this::parMapList;
    }

    public <B> F<F<B, A>, F<List<B>, List<A>>> parMapList1() {
        return f1 -> bs -> this.parMap1((F)f1, (List)bs);
    }

    public <B> F<Array<B>, P1<Array<A>>> parMapArray(F<B, A> f) {
        return as -> this.parMap(f, (Array)as);
    }

    public <B> F<F<B, A>, F<Array<B>, P1<Array<A>>>> parMapArray() {
        return this::parMapArray;
    }

    public <B> F<F<B, A>, F<Array<B>, Array<A>>> parMapArray1() {
        return f1 -> bs -> this.parMap1((F)f1, (Array)bs);
    }

    public static <A, B> P1<List<B>> parFlatMap(Strategy<List<B>> s, F<A, List<B>> f, List<A> as) {
        return P1.map_(List.join()).f(s.parMap(f, as));
    }

    public static <A, B> P1<Array<B>> parFlatMap(Strategy<Array<B>> s, F<A, Array<B>> f, Array<A> as) {
        return P1.map_(Array.join()).f(s.parMap(f, as));
    }

    public static <A> P1<List<A>> parListChunk(Strategy<List<A>> s, int chunkLength, List<P1<A>> as) {
        return P1.map_(List.join()).f(s.parList(as.partition(chunkLength).map(P1.sequenceList())));
    }

    public <B, C> P1<List<A>> parZipWith(F2<B, C, A> f, List<B> bs, List<C> cs) {
        return P1.sequence(bs.zipWith(cs, this.concurry(f)));
    }

    public <B, C> P1<Array<A>> parZipWith(F2<B, C, A> f, Array<B> bs, Array<C> cs) {
        return P1.sequence(bs.zipWith(cs, this.concurry(f)));
    }

    public <B, C> F2<List<B>, List<C>, P1<List<A>>> parZipListWith(F2<B, C, A> f) {
        return (bs, cs) -> this.parZipWith(f, (List)bs, (List)cs);
    }

    public <B, C> F2<Array<B>, Array<C>, P1<Array<A>>> parZipArrayWith(F2<B, C, A> f) {
        return (bs, cs) -> this.parZipWith(f, (Array)bs, (Array)cs);
    }

    public static <A> F<Future<A>, P1<A>> obtain() {
        return Strategy::obtain;
    }

    public static <A> P1<A> obtain(Future<A> t) {
        return P.lazy(() -> {
            try {
                return t.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error(e);
            }
            catch (ExecutionException e) {
                throw new Error(e);
            }
        });
    }

    public static <A> Effect1<Future<A>> discard() {
        return a -> Strategy.obtain().f((Future<Future>)a)._1();
    }

    public static <A> Strategy<A> simpleThreadStrategy() {
        return Strategy.strategy(p -> {
            FutureTask t = new FutureTask(Java.P1_Callable().f((P1<P1>)p));
            new Thread(t).start();
            return Strategy.obtain(t);
        });
    }

    public static <A> Strategy<A> executorStrategy(ExecutorService s) {
        return Strategy.strategy(p -> Strategy.obtain(s.submit(Java.P1_Callable().f((P1<P1>)p))));
    }

    public static <A> Strategy<A> completionStrategy(CompletionService<A> s) {
        return Strategy.strategy(p -> Strategy.obtain(s.submit(Java.P1_Callable().f((P1<P1>)p))));
    }

    public static <A> Strategy<A> seqStrategy() {
        return Strategy.strategy(a -> P.p(a._1()));
    }

    public static <A> Strategy<A> idStrategy() {
        return Strategy.strategy(Function.identity());
    }

    public <B> Strategy<B> xmap(F<P1<A>, P1<B>> f, F<P1<B>, P1<A>> g) {
        return Strategy.strategy(Function.compose(f, Function.compose(this.f(), g)));
    }

    public Strategy<A> map(F<P1<A>, P1<A>> f) {
        return this.xmap(f, Function.identity());
    }

    public Strategy<A> contramap(F<P1<A>, P1<A>> f) {
        return this.xmap(Function.identity(), f);
    }

    public Strategy<A> errorStrategy(Effect1<Error> e) {
        return Strategy.errorStrategy(this, e);
    }

    public static <A> Strategy<A> errorStrategy(Strategy<A> s, Effect1<Error> e) {
        return s.contramap(a -> P.lazy(() -> {
            try {
                return a._1();
            }
            catch (Throwable t) {
                Error error = new Error(t);
                e.f(error);
                throw error;
            }
        }));
    }

    public static <A> Strategy<Callable<A>> callableStrategy(Strategy<Callable<A>> s) {
        return s.contramap(a -> P1.curry(Callables.normalise()).f(a._1()));
    }
}

