/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.Assert;
import org.junit.Rule;

public class Issue661Test {
    @Rule
    public ThreadCheck zombies = new ThreadCheck();
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);
    private boolean wasError = false;

    public void testIssue() throws Exception {
        System.setErr(new TestPrintStream(System.err));
        int port = SocketUtil.getAvailablePort();
        WebSocketServer server0 = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                Assert.fail((String)"There should be no onOpen");
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Assert.fail((String)"There should be no onClose");
            }

            public void onMessage(WebSocket conn, String message) {
                Assert.fail((String)"There should be no onMessage");
            }

            public void onError(WebSocket conn, Exception ex) {
                Assert.fail((String)"There should be no onError!");
            }

            public void onStart() {
                Issue661Test.this.countServerDownLatch.countDown();
            }
        };
        server0.start();
        try {
            this.countServerDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WebSocketServer server1 = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                Assert.fail((String)"There should be no onOpen");
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Assert.fail((String)"There should be no onClose");
            }

            public void onMessage(WebSocket conn, String message) {
                Assert.fail((String)"There should be no onMessage");
            }

            public void onError(WebSocket conn, Exception ex) {
                if (!(ex instanceof BindException)) {
                    Assert.fail((String)"There should be no onError");
                }
            }

            public void onStart() {
                Assert.fail((String)"There should be no onStart!");
            }
        };
        server1.start();
        Thread.sleep(1000L);
        server1.stop();
        server0.stop();
        Thread.sleep(100L);
        Assert.assertTrue((String)"There was an error using System.err", (!this.wasError ? 1 : 0) != 0);
    }

    class TestPrintStream
    extends PrintStream {
        public TestPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void println(Object o) {
            Issue661Test.this.wasError = true;
            super.println(o);
        }
    }
}

