/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.drafts;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.enums.CloseHandshakeType;
import org.java_websocket.enums.HandshakeState;
import org.java_websocket.extensions.DefaultExtension;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.TextFrame;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeImpl1Client;
import org.java_websocket.handshake.HandshakeImpl1Server;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.protocols.Protocol;
import org.java_websocket.util.Charsetfunctions;
import org.junit.Assert;
import org.junit.Test;

public class Draft_6455Test {
    HandshakeImpl1Client handshakedataProtocolExtension = new HandshakeImpl1Client();
    HandshakeImpl1Client handshakedataProtocol;
    HandshakeImpl1Client handshakedataExtension;
    HandshakeImpl1Client handshakedata;

    public Draft_6455Test() {
        this.handshakedataProtocolExtension.put("Upgrade", "websocket");
        this.handshakedataProtocolExtension.put("Connection", "Upgrade");
        this.handshakedataProtocolExtension.put("Sec-WebSocket-Version", "13");
        this.handshakedataProtocolExtension.put("Sec-WebSocket-Extension", "permessage-deflate");
        this.handshakedataProtocolExtension.put("Sec-WebSocket-Protocol", "chat, test");
        this.handshakedataProtocol = new HandshakeImpl1Client();
        this.handshakedataProtocol.put("Upgrade", "websocket");
        this.handshakedataProtocol.put("Connection", "Upgrade");
        this.handshakedataProtocol.put("Sec-WebSocket-Version", "13");
        this.handshakedataProtocol.put("Sec-WebSocket-Protocol", "chat, test");
        this.handshakedataExtension = new HandshakeImpl1Client();
        this.handshakedataExtension.put("Upgrade", "websocket");
        this.handshakedataExtension.put("Connection", "Upgrade");
        this.handshakedataExtension.put("Sec-WebSocket-Version", "13");
        this.handshakedataExtension.put("Sec-WebSocket-Extension", "permessage-deflate");
        this.handshakedata = new HandshakeImpl1Client();
        this.handshakedata.put("Upgrade", "websocket");
        this.handshakedata.put("Connection", "Upgrade");
        this.handshakedata.put("Sec-WebSocket-Version", "13");
    }

    @Test
    public void testConstructor() throws Exception {
        Draft_6455 draft_64552;
        try {
            draft_64552 = new Draft_6455(null, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException draft_64552) {
            // empty catch block
        }
        try {
            draft_64552 = new Draft_6455(Collections.emptyList(), null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException draft_64553) {
            // empty catch block
        }
        try {
            draft_64552 = new Draft_6455(null, Collections.emptyList());
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException draft_64554) {
            // empty catch block
        }
        try {
            draft_64552 = new Draft_6455(Collections.emptyList(), Collections.emptyList(), -1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException draft_64555) {
            // empty catch block
        }
        try {
            draft_64552 = new Draft_6455(Collections.emptyList(), Collections.emptyList(), 0);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException draft_64556) {
            // empty catch block
        }
        draft_64552 = new Draft_6455(Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)1L, (long)draft_64552.getKnownExtensions().size());
        Assert.assertEquals((long)0L, (long)draft_64552.getKnownProtocols().size());
    }

    @Test
    public void testGetExtension() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertNotNull((Object)draft_6455.getExtension());
        assert (draft_6455.getExtension() instanceof DefaultExtension);
    }

    @Test
    public void testGetKnownExtensions() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertEquals((long)1L, (long)draft_6455.getKnownExtensions().size());
        draft_6455 = new Draft_6455((IExtension)new DefaultExtension());
        Assert.assertEquals((long)1L, (long)draft_6455.getKnownExtensions().size());
        draft_6455 = new Draft_6455((IExtension)new TestExtension());
        Assert.assertEquals((long)2L, (long)draft_6455.getKnownExtensions().size());
    }

    @Test
    public void testGetProtocol() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertNull((Object)draft_6455.getProtocol());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertNull((Object)draft_6455.getProtocol());
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Assert.assertNull((Object)draft_6455.getProtocol());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertNotNull((Object)draft_6455.getProtocol());
    }

    @Test
    public void testGetKnownProtocols() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertEquals((long)1L, (long)draft_6455.getKnownProtocols().size());
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)0L, (long)draft_6455.getKnownProtocols().size());
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Assert.assertEquals((long)1L, (long)draft_6455.getKnownProtocols().size());
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol("test"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        Assert.assertEquals((long)2L, (long)draft_6455.getKnownProtocols().size());
    }

    @Test
    public void testCopyInstance() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455(Collections.singletonList(new TestExtension()), Collections.singletonList(new Protocol("chat")));
        Draft_6455 draftCopy = (Draft_6455)draft_6455.copyInstance();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertNotEquals((Object)draft_6455, (Object)draftCopy);
        Assert.assertEquals((Object)draft_6455.getKnownProtocols(), (Object)draftCopy.getKnownProtocols());
        Assert.assertEquals((Object)draft_6455.getKnownExtensions(), (Object)draftCopy.getKnownExtensions());
        Assert.assertNotEquals((Object)draft_6455.getProtocol(), (Object)draftCopy.getProtocol());
        Assert.assertNotEquals((Object)draft_6455.getExtension(), (Object)draftCopy.getExtension());
    }

    @Test
    public void testReset() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455(Collections.singletonList(new TestExtension()), 100);
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        ArrayList extensionList = new ArrayList(draft_6455.getKnownExtensions());
        ArrayList protocolList = new ArrayList(draft_6455.getKnownProtocols());
        draft_6455.reset();
        Assert.assertEquals((Object)new DefaultExtension(), (Object)draft_6455.getExtension());
        Assert.assertNull((Object)draft_6455.getProtocol());
        Assert.assertEquals(extensionList, (Object)draft_6455.getKnownExtensions());
        Assert.assertEquals(protocolList, (Object)draft_6455.getKnownProtocols());
    }

    @Test
    public void testGetCloseHandshakeType() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertEquals((Object)CloseHandshakeType.TWOWAY, (Object)draft_6455.getCloseHandshakeType());
    }

    @Test
    public void testToString() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension protocol: chat max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455 = new Draft_6455(Collections.singletonList(new TestExtension()), Collections.singletonList(new Protocol("chat")));
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertEquals((Object)"Draft_6455 extension: TestExtension protocol: chat max frame size: 2147483647", (Object)draft_6455.toString());
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")), 10);
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension max frame size: 10", (Object)draft_6455.toString());
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertEquals((Object)"Draft_6455 extension: DefaultExtension protocol: chat max frame size: 10", (Object)draft_6455.toString());
    }

    @Test
    public void testEquals() throws Exception {
        Draft_6455 draft0 = new Draft_6455();
        Draft draft1 = draft0.copyInstance();
        Assert.assertEquals((Object)draft0, (Object)draft1);
        Draft_6455 draft2 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Draft draft3 = draft2.copyInstance();
        Assert.assertEquals((Object)draft2, (Object)draft3);
        Assert.assertEquals((Object)draft0, (Object)draft2);
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertNotEquals((Object)draft2, (Object)draft3);
        Assert.assertNotEquals((Object)draft0, (Object)draft2);
        Assert.assertEquals((Object)draft0, (Object)draft1);
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        Assert.assertNotEquals((Object)draft2, (Object)draft3);
        Assert.assertNotEquals((Object)draft0, (Object)draft2);
        Assert.assertEquals((Object)draft0, (Object)draft1);
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        Assert.assertEquals((Object)draft2, (Object)draft3);
        Assert.assertEquals((Object)draft0, (Object)draft2);
        Assert.assertNotEquals((Object)draft0, (Object)draft1);
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedata);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedata);
        Assert.assertEquals((Object)draft2, (Object)draft3);
        Assert.assertEquals((Object)draft0, (Object)draft2);
        Assert.assertNotEquals((Object)draft0, (Object)draft1);
    }

    @Test
    public void testHashCode() throws Exception {
        Draft_6455 draft0 = new Draft_6455();
        Draft draft1 = draft0.copyInstance();
        Draft_6455 draft2 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Draft draft3 = draft2.copyInstance();
        Assert.assertEquals((long)draft2.hashCode(), (long)draft3.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft2.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft1.hashCode());
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        Assert.assertNotEquals((long)draft2.hashCode(), (long)draft3.hashCode());
        Assert.assertNotEquals((long)draft0.hashCode(), (long)draft2.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft1.hashCode());
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        Assert.assertNotEquals((long)draft2.hashCode(), (long)draft3.hashCode());
        Assert.assertNotEquals((long)draft0.hashCode(), (long)draft2.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft1.hashCode());
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        Assert.assertEquals((long)draft2.hashCode(), (long)draft3.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft2.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft1.hashCode());
        draft2 = draft2.copyInstance();
        draft1 = draft1.copyInstance();
        draft2.acceptHandshakeAsServer((ClientHandshake)this.handshakedata);
        draft1.acceptHandshakeAsServer((ClientHandshake)this.handshakedata);
        Assert.assertEquals((long)draft2.hashCode(), (long)draft3.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft2.hashCode());
        Assert.assertEquals((long)draft0.hashCode(), (long)draft1.hashCode());
    }

    @Test
    public void acceptHandshakeAsServer() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedata));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension));
        draft_6455 = new Draft_6455((IExtension)new TestExtension());
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedata));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension));
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedata));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol));
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension));
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        protocols.add(new Protocol(""));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedata));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension));
    }

    @Test
    public void acceptHandshakeAsClient() throws Exception {
        HandshakeImpl1Server response = new HandshakeImpl1Server();
        HandshakeImpl1Client request = new HandshakeImpl1Client();
        Draft_6455 draft_6455 = new Draft_6455();
        response.put("Upgrade", "websocket");
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        response.put("Connection", "upgrade");
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        response.put("Sec-WebSocket-Version", "13");
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        request.put("Sec-WebSocket-Key", "dGhlIHNhbXBsZSBub25jZQ==");
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        response.put("Sec-WebSocket-Accept", "s3pPLMBiTxaQ9kYGzzhZRbK+xOo=");
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        response.put("Sec-WebSocket-Protocol", "chat");
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol(""));
        protocols.add(new Protocol("chat"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        Assert.assertEquals((Object)HandshakeState.MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        draft_6455 = new Draft_6455();
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
        protocols.clear();
        protocols.add(new Protocol("chat3"));
        protocols.add(new Protocol("3chat"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        Assert.assertEquals((Object)HandshakeState.NOT_MATCHED, (Object)draft_6455.acceptHandshakeAsClient((ClientHandshake)request, (ServerHandshake)response));
    }

    @Test
    public void postProcessHandshakeRequestAsClient() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        HandshakeImpl1Client request = new HandshakeImpl1Client();
        draft_6455.postProcessHandshakeRequestAsClient((ClientHandshakeBuilder)request);
        Assert.assertEquals((Object)"websocket", (Object)request.getFieldValue("Upgrade"));
        Assert.assertEquals((Object)"Upgrade", (Object)request.getFieldValue("Connection"));
        Assert.assertEquals((Object)"13", (Object)request.getFieldValue("Sec-WebSocket-Version"));
        Assert.assertTrue((boolean)request.hasFieldValue("Sec-WebSocket-Key"));
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("chat"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        request = new HandshakeImpl1Client();
        draft_6455.postProcessHandshakeRequestAsClient((ClientHandshakeBuilder)request);
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"chat", (Object)request.getFieldValue("Sec-WebSocket-Protocol"));
        protocols.add(new Protocol("chat2"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        request = new HandshakeImpl1Client();
        draft_6455.postProcessHandshakeRequestAsClient((ClientHandshakeBuilder)request);
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"chat, chat2", (Object)request.getFieldValue("Sec-WebSocket-Protocol"));
        protocols.clear();
        protocols.add(new Protocol(""));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        request = new HandshakeImpl1Client();
        draft_6455.postProcessHandshakeRequestAsClient((ClientHandshakeBuilder)request);
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        Assert.assertTrue((!request.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
    }

    @Test
    public void postProcessHandshakeResponseAsServer() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        HandshakeImpl1Server response = new HandshakeImpl1Server();
        HandshakeImpl1Client request = new HandshakeImpl1Client();
        request.put("Sec-WebSocket-Key", "dGhlIHNhbXBsZSBub25jZQ==");
        request.put("Connection", "upgrade");
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((boolean)response.hasFieldValue("Date"));
        Assert.assertTrue((boolean)response.hasFieldValue("Sec-WebSocket-Accept"));
        Assert.assertEquals((Object)"Web Socket Protocol Handshake", (Object)response.getHttpStatusMessage());
        Assert.assertEquals((Object)"TooTallNate Java-WebSocket", (Object)response.getFieldValue("Server"));
        Assert.assertEquals((Object)"upgrade", (Object)response.getFieldValue("Connection"));
        Assert.assertEquals((Object)"websocket", (Object)response.getFieldValue("Upgrade"));
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedata);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455 = new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol("chat")));
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertEquals((Object)"chat", (Object)response.getFieldValue("Sec-WebSocket-Protocol"));
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.reset();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.reset();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertEquals((Object)"chat", (Object)response.getFieldValue("Sec-WebSocket-Protocol"));
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(new Protocol("test"));
        protocols.add(new Protocol("chat"));
        draft_6455 = new Draft_6455(Collections.emptyList(), protocols);
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocol);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertEquals((Object)"test", (Object)response.getFieldValue("Sec-WebSocket-Protocol"));
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.reset();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Protocol") ? 1 : 0) != 0);
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
        response = new HandshakeImpl1Server();
        draft_6455.reset();
        draft_6455.acceptHandshakeAsServer((ClientHandshake)this.handshakedataProtocolExtension);
        draft_6455.postProcessHandshakeResponseAsServer((ClientHandshake)request, (ServerHandshakeBuilder)response);
        Assert.assertEquals((Object)"test", (Object)response.getFieldValue("Sec-WebSocket-Protocol"));
        Assert.assertTrue((!response.hasFieldValue("Sec-WebSocket-Extensions") ? 1 : 0) != 0);
    }

    @Test
    public void createFramesBinary() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        BinaryFrame curframe = new BinaryFrame();
        ByteBuffer test0 = ByteBuffer.wrap("Test0".getBytes());
        curframe.setPayload(test0);
        curframe.setTransferemasked(false);
        List createdFrame = draft_6455.createFrames(test0, false);
        Assert.assertEquals((long)1L, (long)createdFrame.size());
        Assert.assertEquals((Object)curframe, createdFrame.get(0));
        curframe = new BinaryFrame();
        ByteBuffer test1 = ByteBuffer.wrap("Test1".getBytes());
        curframe.setPayload(test1);
        curframe.setTransferemasked(true);
        createdFrame = draft_6455.createFrames(test1, true);
        Assert.assertEquals((long)1L, (long)createdFrame.size());
        Assert.assertEquals((Object)curframe, createdFrame.get(0));
    }

    @Test
    public void createFramesText() throws Exception {
        Draft_6455 draft_6455 = new Draft_6455();
        TextFrame curframe = new TextFrame();
        curframe.setPayload(ByteBuffer.wrap(Charsetfunctions.utf8Bytes((String)"Test0")));
        curframe.setTransferemasked(false);
        List createdFrame = draft_6455.createFrames("Test0", false);
        Assert.assertEquals((long)1L, (long)createdFrame.size());
        Assert.assertEquals((Object)curframe, createdFrame.get(0));
        curframe = new TextFrame();
        curframe.setPayload(ByteBuffer.wrap(Charsetfunctions.utf8Bytes((String)"Test0")));
        curframe.setTransferemasked(true);
        createdFrame = draft_6455.createFrames("Test0", true);
        Assert.assertEquals((long)1L, (long)createdFrame.size());
        Assert.assertEquals((Object)curframe, createdFrame.get(0));
    }

    private class TestExtension
    extends DefaultExtension {
        private TestExtension() {
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public IExtension copyInstance() {
            return new TestExtension();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == o.getClass();
        }
    }
}

