/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.ControlFrame;
import org.junit.Assert;
import org.junit.Test;

public class CloseFrameTest {
    @Test
    public void testConstructor() {
        CloseFrame frame = new CloseFrame();
        Assert.assertEquals((String)"Opcode must be equal", (Object)Opcode.CLOSING, (Object)frame.getOpcode());
        Assert.assertEquals((String)"Fin must be set", (Object)true, (Object)frame.isFin());
        Assert.assertEquals((String)"TransferedMask must not be set", (Object)false, (Object)frame.getTransfereMasked());
        Assert.assertEquals((String)"Payload must be 2 (close code)", (long)2L, (long)frame.getPayloadData().capacity());
        Assert.assertEquals((String)"RSV1 must be false", (Object)false, (Object)frame.isRSV1());
        Assert.assertEquals((String)"RSV2 must be false", (Object)false, (Object)frame.isRSV2());
        Assert.assertEquals((String)"RSV3 must be false", (Object)false, (Object)frame.isRSV3());
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
    }

    @Test
    public void testExtends() {
        CloseFrame frame = new CloseFrame();
        Assert.assertEquals((String)"Frame must extend dataframe", (Object)true, (Object)(frame instanceof ControlFrame));
    }

    @Test
    public void testToString() {
        CloseFrame frame = new CloseFrame();
        String frameString = frame.toString();
        frameString = frameString.replaceAll("payload:(.*)}", "payload: *}");
        Assert.assertEquals((String)"Frame toString must include a close code", (Object)"Framedata{ optcode:CLOSING, fin:true, rsv1:false, rsv2:false, rsv3:false, payloadlength:[pos:0, len:2], payload: *}code: 1000", (Object)frameString);
    }

    @Test
    public void testIsValid() {
        CloseFrame frame = new CloseFrame();
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setFin(false);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setFin(true);
        frame.setRSV1(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setRSV1(false);
        frame.setRSV2(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setRSV2(false);
        frame.setRSV3(true);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setRSV3(false);
        frame.setCode(1000);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1001);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1002);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1003);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1005);
        Assert.assertEquals((long)0L, (long)frame.getPayloadData().capacity());
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setCode(1006);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        frame.setCode(1008);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1009);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1010);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1011);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1012);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1013);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1014);
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame.setCode(1015);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(-1);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(-2);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(-3);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(1005);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(1007);
        frame.setReason(null);
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        frame.setCode(1005);
        frame.setReason("Close");
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }
}

