/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue713Test {
    CountDownLatch countDownLatchString = new CountDownLatch(10);
    CountDownLatch countDownLatchConnect = new CountDownLatch(10);
    CountDownLatch countDownLatchBytebuffer = new CountDownLatch(10);

    @Test
    public void testIllegalArgument() throws IOException {
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(SocketUtil.getAvailablePort())){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
            }
        };
        try {
            server.broadcast((byte[])null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            server.broadcast((String)null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=2000L)
    public void testIssue() throws Exception {
        final int port = SocketUtil.getAvailablePort();
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                try {
                    for (int i = 0; i < 10; ++i) {
                        TestWebSocket tw = new TestWebSocket(port);
                        tw.connect();
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)"Exception during connect!");
                }
            }
        };
        server.start();
        this.countDownLatchConnect.await();
        server.broadcast("Hello world!");
        this.countDownLatchString.await();
        server.broadcast("Hello world".getBytes());
        this.countDownLatchBytebuffer.await();
        this.countDownLatchBytebuffer = new CountDownLatch(10);
        server.broadcast(ByteBuffer.wrap("Hello world".getBytes()));
        this.countDownLatchBytebuffer.await();
        this.countDownLatchString = new CountDownLatch(5);
        ArrayList specialList = new ArrayList(server.getConnections());
        specialList.remove(8);
        specialList.remove(6);
        specialList.remove(4);
        specialList.remove(2);
        specialList.remove(0);
        server.broadcast("Hello world", specialList);
        this.countDownLatchString.await();
        this.countDownLatchBytebuffer = new CountDownLatch(5);
        server.broadcast("Hello world".getBytes());
        this.countDownLatchBytebuffer.await();
    }

    class TestWebSocket
    extends WebSocketClient {
        TestWebSocket(int port) throws URISyntaxException {
            super(new URI("ws://localhost:" + port));
        }

        public void onOpen(ServerHandshake handshakedata) {
            Issue713Test.this.countDownLatchConnect.countDown();
        }

        public void onMessage(String message) {
            Issue713Test.this.countDownLatchString.countDown();
        }

        public void onMessage(ByteBuffer message) {
            Issue713Test.this.countDownLatchBytebuffer.countDown();
        }

        public void onClose(int code, String reason, boolean remote) {
        }

        public void onError(Exception ex) {
        }
    }
}

