/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.Scanner;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.util.Charsetfunctions;
import org.java_websocket.util.SocketUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OpeningHandshakeRejectionTest {
    private static final String additionalHandshake = "Upgrade: websocket\r\nConnection: Upgrade\r\n\r\n";
    private static int counter = 0;
    private static Thread thread;
    private static ServerSocket serverSocket;
    private static boolean debugPrintouts;
    private static int port;

    @BeforeClass
    public static void startServer() throws Exception {
        port = SocketUtil.getAvailablePort();
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverSocket = new ServerSocket(port);
                    serverSocket.setReuseAddress(true);
                    while (true) {
                        Socket client = null;
                        try {
                            client = serverSocket.accept();
                            Scanner in = new Scanner(client.getInputStream());
                            String input = in.nextLine();
                            String testCase = input.split(" ")[1];
                            OutputStream os = client.getOutputStream();
                            if ("/0".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 100 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/1".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.0 100 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/2".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP 100 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/3".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 200 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/4".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/5".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 404 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/6".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/2.0 404 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/7".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 500 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/8".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"GET 302 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/9".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"GET HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if ("/10".equals(testCase)) {
                                os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                                os.flush();
                            }
                            if (!"/11".equals(testCase)) continue;
                            os.write(Charsetfunctions.asciiBytes((String)"HTTP/1.1 101 Websocket Connection Upgrade\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n\r\n"));
                            os.flush();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)"There should be no exception");
                    return;
                }
            }
        });
        thread.start();
    }

    @AfterClass
    public static void successTests() throws InterruptedException, IOException {
        serverSocket.close();
        thread.interrupt();
        if (debugPrintouts) {
            System.out.println(counter + " successful tests");
        }
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase0() throws Exception {
        this.testHandshakeRejection(0);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase1() throws Exception {
        this.testHandshakeRejection(1);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase2() throws Exception {
        this.testHandshakeRejection(2);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase3() throws Exception {
        this.testHandshakeRejection(3);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase4() throws Exception {
        this.testHandshakeRejection(4);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase5() throws Exception {
        this.testHandshakeRejection(5);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase6() throws Exception {
        this.testHandshakeRejection(6);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase7() throws Exception {
        this.testHandshakeRejection(7);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase8() throws Exception {
        this.testHandshakeRejection(8);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase9() throws Exception {
        this.testHandshakeRejection(9);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase10() throws Exception {
        this.testHandshakeRejection(10);
    }

    @Test(timeout=5000L)
    public void testHandshakeRejectionTestCase11() throws Exception {
        this.testHandshakeRejection(11);
    }

    private void testHandshakeRejection(int i) throws Exception {
        final int finalI = i;
        final boolean[] threadReturned = new boolean[]{false};
        WebSocketClient webSocketClient = new WebSocketClient(new URI("ws://localhost:" + port + "/" + finalI)){

            public void onOpen(ServerHandshake handshakedata) {
                Assert.fail((String)"There should not be a connection!");
            }

            public void onMessage(String message) {
                Assert.fail((String)"There should not be a message!");
            }

            public void onClose(int code, String reason, boolean remote) {
                if (finalI != 10 && finalI != 11) {
                    if (code != 1002) {
                        Assert.fail((String)"There should be a protocol error!");
                    } else if (reason.startsWith("Invalid status code received:") || reason.startsWith("Invalid status line received:")) {
                        if (debugPrintouts) {
                            System.out.println("Protocol error for test case: " + finalI);
                        }
                        threadReturned[0] = true;
                        counter++;
                    } else {
                        Assert.fail((String)"The reason should be included!");
                    }
                } else if (!reason.endsWith("refuses handshake")) {
                    Assert.fail((String)"onClose should not be called!");
                } else {
                    if (debugPrintouts) {
                        System.out.println("Refuses handshake error for test case: " + finalI);
                    }
                    counter++;
                    threadReturned[0] = true;
                }
            }

            public void onError(Exception ex) {
                Assert.fail((String)"There should not be an exception");
            }
        };
        Thread finalThread = new Thread((Runnable)webSocketClient);
        finalThread.start();
        finalThread.join();
        if (!threadReturned[0]) {
            Assert.fail((String)"Error");
        }
    }

    static {
        debugPrintouts = false;
    }
}

