/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.features.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.features.FirewallClient;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FirewallClientExpectTest")
public class FirewallClientExpectTest
extends BaseCloudStackRestClientExpectTest<FirewallClient> {
    public void testListFirewallRulesWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&apiKey=identity&signature=MktZKKH3USVKiC9SlYTSHMCaCcg%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listfirewallrulesresponse.json")).build());
        ImmutableSet CIDRs = ImmutableSet.of((Object)"0.0.0.0/0");
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of((Object)FirewallRule.builder().id(2017L).protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId(2L).ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id(2016L).protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId(2L).ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id(10L).protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId(8L).ipAddress("10.27.27.57").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build()));
    }

    public void testListFirewallRulesWhenReponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&apiKey=identity&signature=MktZKKH3USVKiC9SlYTSHMCaCcg%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetFirewallRuleWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&id=2017&apiKey=identity&signature=0r5iL%2Bzix9rmD07lJIOhY68mYY0%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getfirewallrulesresponse.json")).build());
        Assert.assertEquals((Object)client.getFirewallRule(2017L), (Object)FirewallRule.builder().id(2017L).protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId(2L).ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)ImmutableSet.of((Object)"0.0.0.0/0")).build());
    }

    public void testGetFirewallRuleWhenResponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&id=4&apiKey=identity&signature=PPX5U9kmaS116SgG4Ihf8xK%2BcSE%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getFirewallRule(4L));
    }

    public void testCreateFirewallRuleForIpAndProtocol() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createFirewallRule&ipaddressid=2&protocol=TCP&apiKey=identity&signature=d0MZ%2FyhQPAaV%2BYQmfZsQtQL2C28%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createfirewallrulesresponse.json")).build());
        AsyncCreateResponse response = client.createFirewallRuleForIpAndProtocol(2L, FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[0]);
        Assert.assertEquals((long)response.getJobId(), (long)2036L);
        Assert.assertEquals((long)response.getId(), (long)2017L);
    }

    public void testDeleteFirewallRule() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteFirewallRule&id=2015&apiKey=identity&signature=%2FT5FAO2yGPctaPmg7TEtIEFW3EU%3D")).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletefirewallrulesresponse.json")).build());
        client.deleteFirewallRule(2015L);
    }

    public void testListPortForwardingRulesWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&apiKey=identity&signature=YFBu1VOSkiDKxm0K42sIXJWy%2BBo%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listportforwardingrulesresponse.json")).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of((Object)PortForwardingRule.builder().id(15L).privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId(3L).virtualMachineName("i-3-3-VM").IPAddressId(3L).IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).build(), (Object)PortForwardingRule.builder().id(18L).privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(22).virtualMachineId(89L).virtualMachineName("i-3-89-VM").IPAddressId(34L).IPAddress("72.52.126.63").state(PortForwardingRule.State.ACTIVE).build()));
    }

    public void testListPortForwardingRulesWhenReponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&apiKey=identity&signature=YFBu1VOSkiDKxm0K42sIXJWy%2BBo%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetPortForwardingRuleWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&id=15&apiKey=identity&signature=ABJsciF4n2tXaiyUmEvc3oYh9MA%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getportforwardingrulesresponse.json")).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Object)client.getPortForwardingRule(15L), (Object)PortForwardingRule.builder().id(15L).privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId(3L).virtualMachineName("i-3-3-VM").IPAddressId(3L).IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).build());
    }

    public void testGetPortForwardingRuleWhenResponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&id=4&apiKey=identity&signature=CTOmmIOGIiZx0YATqh%2FFk0zIplw%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getPortForwardingRule(4L));
    }

    public void testCreatePortForwardingRuleForVirtualMachine() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createPortForwardingRule&ipaddressid=2&publicport=22&protocol=tcp&virtualmachineid=1234&privateport=22&apiKey=identity&signature=84dtGzQp0G6k3z3Gkc3F%2FHBNS2Y%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createportforwardingrulesresponse.json")).build());
        AsyncCreateResponse response = client.createPortForwardingRuleForVirtualMachine(2L, PortForwardingRule.Protocol.TCP, 22, 1234L, 22);
        Assert.assertEquals((long)response.getJobId(), (long)2035L);
        Assert.assertEquals((long)response.getId(), (long)2015L);
    }

    public void testDeletePortForwardingRule() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deletePortForwardingRule&id=2015&apiKey=identity&signature=2UE7KB3wm5ocmR%2BGMNFKPKfiDo8%3D")).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deleteportforwardingrulesresponse.json")).build());
        client.deletePortForwardingRule(2015L);
    }

    @Override
    protected FirewallClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)context.getProviderSpecificContext().getApi()).getFirewallClient();
    }
}

