/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListSSHKeyPairsOptions;
import org.jclouds.crypto.SshKeys;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SSHKeyPairClientLiveTest")
public class SSHKeyPairClientLiveTest
extends BaseCloudStackClientLiveTest {
    protected String prefix = System.getProperty("user.name");
    private String keyPairName = this.prefix + "-jclouds-keypair";
    private SshKeyPair sshKeyPair;

    @BeforeMethod
    @AfterMethod
    public void removeExistingKey() {
        this.client.getSSHKeyPairClient().deleteSSHKeyPair(this.keyPairName);
    }

    public void testListSSHKeyPairs() {
        Set sshKeyPairs = this.client.getSSHKeyPairClient().listSSHKeyPairs(new ListSSHKeyPairsOptions[0]);
        for (SshKeyPair sshKeyPair : sshKeyPairs) {
            this.checkSSHKeyPair(sshKeyPair);
        }
    }

    public void testCreateDeleteSSHKeyPair() {
        this.sshKeyPair = this.client.getSSHKeyPairClient().createSSHKeyPair(this.keyPairName);
        this.checkSSHKeyPair(this.sshKeyPair);
        this.client.getSSHKeyPairClient().deleteSSHKeyPair(this.sshKeyPair.getName());
        Assert.assertEquals((Object)this.client.getSSHKeyPairClient().getSSHKeyPair(this.sshKeyPair.getName()), null);
        Assert.assertEquals((String)SshKeys.fingerprintPrivateKey((String)this.sshKeyPair.getPrivateKey()), (String)this.sshKeyPair.getFingerprint());
        this.sshKeyPair = null;
    }

    public void testRegisterDeleteSSHKeyPair() {
        Map sshKey = SshKeys.generate();
        String publicKey = (String)sshKey.get("public");
        this.sshKeyPair = this.client.getSSHKeyPairClient().registerSSHKeyPair(this.keyPairName, publicKey);
        this.checkSSHKeyPair(this.sshKeyPair);
        this.client.getSSHKeyPairClient().deleteSSHKeyPair(this.keyPairName);
        Assert.assertEquals((Object)this.client.getSSHKeyPairClient().getSSHKeyPair(this.sshKeyPair.getName()), null);
        this.sshKeyPair = null;
    }

    protected void checkSSHKeyPair(SshKeyPair pair) {
        assert (pair.getName() != null) : pair;
        Assert.assertEquals((String)pair.toString(), (String)this.client.getSSHKeyPairClient().getSSHKeyPair(pair.getName()).toString());
    }
}

