/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineClient;
import org.jclouds.cloudstack.predicates.VirtualMachineRunning;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="VirtualMachineRunningTest")
public class VirtualMachineRunningTest {
    CloudStackClient client;
    VirtualMachineClient virtualMachineClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        this.virtualMachineClient = (VirtualMachineClient)EasyMock.createMock(VirtualMachineClient.class);
        EasyMock.expect((Object)this.client.getVirtualMachineClient()).andReturn((Object)this.virtualMachineClient);
    }

    @DataProvider(name="virtualMachineStates")
    public Object[][] virtualMachineStates() {
        return new Object[][]{{VirtualMachine.State.RUNNING, true}, {VirtualMachine.State.STARTING, false}, {VirtualMachine.State.STOPPING, false}, {VirtualMachine.State.STOPPED, false}, {VirtualMachine.State.SHUTDOWNED, false}, {VirtualMachine.State.DESTROYED, false}, {VirtualMachine.State.EXPUNGING, false}, {VirtualMachine.State.MIGRATING, false}};
    }

    @Test(dataProvider="virtualMachineStates")
    public void testWaitForVirtualMachineToBeRunning(VirtualMachine.State state, boolean expected) {
        this.assertPredicateResult(state, expected);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testThrowExceptionOnErrorState() {
        this.assertPredicateResult(VirtualMachine.State.ERROR, true);
    }

    private void assertPredicateResult(VirtualMachine.State state, boolean expected) {
        long virtualMachineId = 229L;
        VirtualMachine virtualMachine = VirtualMachine.builder().id(virtualMachineId).state(state).build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachineId)).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertEquals((boolean)new VirtualMachineRunning(this.client).apply(virtualMachine), (boolean)expected);
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }
}

