/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Throwables2;

@Singleton
public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    public static final Map<VirtualMachine.State, NodeState> vmStateToNodeState = ImmutableMap.builder().put((Object)VirtualMachine.State.STARTING, (Object)NodeState.PENDING).put((Object)VirtualMachine.State.RUNNING, (Object)NodeState.RUNNING).put((Object)VirtualMachine.State.STOPPING, (Object)NodeState.PENDING).put((Object)VirtualMachine.State.STOPPED, (Object)NodeState.SUSPENDED).put((Object)VirtualMachine.State.DESTROYED, (Object)NodeState.TERMINATED).put((Object)VirtualMachine.State.EXPUNGING, (Object)NodeState.TERMINATED).put((Object)VirtualMachine.State.MIGRATING, (Object)NodeState.PENDING).put((Object)VirtualMachine.State.ERROR, (Object)NodeState.ERROR).put((Object)VirtualMachine.State.UNKNOWN, (Object)NodeState.UNRECOGNIZED).put((Object)VirtualMachine.State.SHUTDOWNED, (Object)NodeState.PENDING).put((Object)VirtualMachine.State.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).build();
    private final FindLocationForVirtualMachine findLocationForVirtualMachine;
    private final FindHardwareForVirtualMachine findHardwareForVirtualMachine;
    private final FindImageForVirtualMachine findImageForVirtualMachine;
    private final LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;

    @Inject
    VirtualMachineToNodeMetadata(FindLocationForVirtualMachine findLocationForVirtualMachine, FindHardwareForVirtualMachine findHardwareForVirtualMachine, FindImageForVirtualMachine findImageForVirtualMachine, LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine) {
        this.findLocationForVirtualMachine = (FindLocationForVirtualMachine)((Object)Preconditions.checkNotNull((Object)((Object)findLocationForVirtualMachine), (Object)"findLocationForVirtualMachine"));
        this.findHardwareForVirtualMachine = (FindHardwareForVirtualMachine)((Object)Preconditions.checkNotNull((Object)((Object)findHardwareForVirtualMachine), (Object)"findHardwareForVirtualMachine"));
        this.findImageForVirtualMachine = (FindImageForVirtualMachine)((Object)Preconditions.checkNotNull((Object)((Object)findImageForVirtualMachine), (Object)"findImageForVirtualMachine"));
        this.getIPForwardingRulesByVirtualMachine = (LoadingCache)Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, (Object)"getIPForwardingRulesByVirtualMachine");
    }

    public NodeMetadata apply(VirtualMachine from) {
        NodeMetadataBuilder builder;
        block7: {
            Hardware hardware;
            builder = new NodeMetadataBuilder();
            builder.ids(from.getId() + "");
            builder.name(from.getName());
            builder.hostname(from.getDisplayName());
            builder.location((Location)this.findLocationForVirtualMachine.apply(from));
            builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getDisplayName()));
            Image image = (Image)this.findImageForVirtualMachine.apply(from);
            if (image != null) {
                builder.imageId(image.getId());
                builder.operatingSystem(image.getOperatingSystem());
            }
            if ((hardware = (Hardware)this.findHardwareForVirtualMachine.apply(from)) != null) {
                builder.hardware(hardware);
            }
            builder.state(vmStateToNodeState.get((Object)from.getState()));
            if (from.getIPAddress() != null) {
                boolean isPrivate = InetAddresses2.isPrivateIPAddress((String)from.getIPAddress());
                ImmutableSet addresses = ImmutableSet.of((Object)from.getIPAddress());
                if (isPrivate) {
                    builder.privateAddresses((Iterable)addresses);
                } else {
                    builder.publicAddresses((Iterable)addresses);
                }
            }
            try {
                builder.publicAddresses(Iterables.transform((Iterable)Iterables.filter((Iterable)((Iterable)this.getIPForwardingRulesByVirtualMachine.getUnchecked((Object)from.getId())), (Predicate)new Predicate<IPForwardingRule>(){

                    public boolean apply(@Nullable IPForwardingRule rule) {
                        return !"Deleting".equals(rule.getState());
                    }
                }), (Function)new Function<IPForwardingRule, String>(){

                    public String apply(@Nullable IPForwardingRule rule) {
                        return rule.getIPAddress();
                    }
                }));
            }
            catch (UncheckedExecutionException e) {
                if (Throwables2.getFirstThrowableOfType((Throwable)e, ResourceNotFoundException.class) != null) break block7;
                Throwables.propagateIfPossible((Throwable)e.getCause());
                throw e;
            }
        }
        return builder.build();
    }

    @Singleton
    public static class FindImageForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Image> {
        @Inject
        public FindImageForVirtualMachine(@Memoized Supplier<Set<? extends Image>> location) {
            super(location);
        }

        public boolean matches(VirtualMachine from, Image input) {
            return input.getProviderId().equals(from.getTemplateId() + "") && (input.getLocation() == null || input.getId().equals(from.getZoneId() + ""));
        }
    }

    @Singleton
    public static class FindHardwareForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Hardware> {
        @Inject
        public FindHardwareForVirtualMachine(@Memoized Supplier<Set<? extends Hardware>> location) {
            super(location);
        }

        public boolean matches(VirtualMachine from, Hardware input) {
            return input.getProviderId().equals(Long.toString(from.getServiceOfferingId()));
        }
    }

    @Singleton
    public static class FindLocationForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Location> {
        @Inject
        public FindLocationForVirtualMachine(@Memoized Supplier<Set<? extends Location>> location) {
            super(location);
        }

        public boolean matches(VirtualMachine from, Location input) {
            return input.getId().equals(Long.toString(from.getZoneId()));
        }
    }
}

