/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;

public class UserPredicates {
    public static Predicate<User> apiKeyEquals(String apiKey) {
        return new ApiKeyEquals(apiKey);
    }

    public static Predicate<User> accountTypeEquals(Account.Type type) {
        return new AccountTypeEquals(type);
    }

    public static Predicate<User> isUserAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.USER);
    }

    public static Predicate<User> isDomainAdminAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.DOMAIN_ADMIN);
    }

    public static Predicate<User> isAdminAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.ADMIN);
    }

    public static class AccountTypeEquals
    implements Predicate<User> {
        private final Account.Type type;

        public AccountTypeEquals(Account.Type type) {
            this.type = (Account.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        }

        public boolean apply(User input) {
            return ((User)Preconditions.checkNotNull((Object)input, (Object)"user")).getAccountType() == this.type;
        }

        public String toString() {
            return "accountTypeEquals(" + (Object)((Object)this.type) + ")";
        }
    }

    public static class ApiKeyEquals
    implements Predicate<User> {
        private final String apiKey;

        public ApiKeyEquals(String apiKey) {
            this.apiKey = (String)Preconditions.checkNotNull((Object)apiKey, (Object)"apiKey");
        }

        public boolean apply(User input) {
            return this.apiKey.equals(((User)Preconditions.checkNotNull((Object)input, (Object)"user")).getApiKey());
        }

        public String toString() {
            return "apiKeyEquals(" + this.apiKey + ")";
        }
    }
}

