/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.cloudstack.features.AccountAsyncClient;
import org.jclouds.cloudstack.features.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccountAsyncClientTest")
public class AccountAsyncClientTest
extends BaseCloudStackAsyncClientTest<AccountAsyncClient> {
    public void testListAccounts() throws SecurityException, NoSuchMethodException, IOException {
        Method method = AccountAsyncClient.class.getMethod("listAccounts", ListAccountsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAccounts HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListAccountsOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = AccountAsyncClient.class.getMethod("listAccounts", ListAccountsOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{ListAccountsOptions.Builder.accountInDomain((String)"jclouds", (long)123L)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAccounts&account=jclouds&domainid=123 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetAccount() throws SecurityException, NoSuchMethodException, IOException {
        Method method = AccountAsyncClient.class.getMethod("getAccount", Long.TYPE);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{3L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listAccounts&id=3 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, Functions.compose((Function)IdentityFunction.INSTANCE, (Function)IdentityFunction.INSTANCE).getClass());
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected TypeLiteral<RestAnnotationProcessor<AccountAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<AccountAsyncClient>>(){};
    }
}

