/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AccountClientLiveTest")
public class AccountClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testListAccounts() throws Exception {
        for (Account securityAccount : this.client.getAccountClient().listAccounts(new ListAccountsOptions[0])) {
            this.checkAccount(securityAccount);
        }
    }

    protected void checkAccount(Account account) {
        assert (account.getId() > 0L) : account;
        Assert.assertEquals((String)account.toString(), (String)this.client.getAccountClient().getAccount(account.getId()).toString());
        assert (account.getName() != null) : account;
        assert (account.getType() != null && account.getType() != Account.Type.UNRECOGNIZED) : account;
        assert (account.getDomain() != null) : account;
        assert (account.getDomainId() >= 0L) : account;
        assert (account.getUsers() != null) : account;
        for (User user : account.getUsers()) {
            assert (user.getName() != null) : user;
            assert (user.getAccountType().equals((Object)account.getType())) : user;
            assert (user.getDomain().equals(account.getDomain())) : user;
            assert (user.getDomainId() == account.getDomainId()) : user;
            assert (user.getApiKey() != null) : user;
            assert (user.getCreated() != null) : user;
            assert (user.getEmail() != null) : user;
            assert (user.getLastName() != null) : user;
            assert (user.getFirstName() != null) : user;
            assert (user.getId() > 0L) : user;
            assert (user.getSecretKey() != null) : user;
            assert (user.getState() != null) : user;
        }
        assert (account.getIPsAvailable() == null || account.getIPsAvailable() >= 0L) : account;
        assert (account.getIPLimit() == null || account.getIPLimit() >= 0L) : account;
        assert (account.getIPs() >= 0L) : account;
        assert (account.getReceivedBytes() >= 0L) : account;
        assert (account.getSentBytes() >= 0L) : account;
        assert (account.getSnapshotsAvailable() == null || account.getSnapshotsAvailable() >= 0L) : account;
        assert (account.getSnapshotLimit() == null || account.getSnapshotLimit() >= 0L) : account;
        assert (account.getSnapshots() >= 0L) : account;
        assert (account.getState() != null && account.getState() != Account.State.UNRECOGNIZED) : account;
        assert (account.getTemplatesAvailable() == null || account.getTemplatesAvailable() >= 0L) : account;
        assert (account.getTemplateLimit() == null || account.getTemplateLimit() >= 0L) : account;
        assert (account.getTemplates() >= 0L) : account;
        assert (account.getVMsAvailable() == null || account.getVMsAvailable() >= 0L) : account;
        assert (account.getVMLimit() == null || account.getVMLimit() >= 0L) : account;
        assert (account.getVMsRunning() >= 0L) : account;
        assert (account.getVMsStopped() >= 0L) : account;
        assert (account.getVMs() >= 0L) : account;
        assert (account.getVolumesAvailable() == null || account.getVolumesAvailable() >= 0L) : account;
        assert (account.getVolumeLimit() == null || account.getVolumeLimit() >= 0L) : account;
        assert (account.getVolumes() >= 0L) : account;
    }
}

