/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainDomainClientLiveTest")
public class DomainDomainClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test
    public void testListDomains() {
        assert (this.domainAdminEnabled);
        Set allDomains = this.domainAdminClient.getDomainClient().listDomains(new ListDomainsOptions[0]);
        Domain root = (Domain)Iterables.find((Iterable)allDomains, this.withName("ROOT"));
        Assert.assertEquals((Object)root, (Object)this.domainAdminClient.getDomainClient().getDomainById(root.getId()));
        Assert.assertEquals((long)root.getLevel(), (long)0L);
        Assert.assertEquals((long)root.getParentDomainId(), (long)0L);
        Assert.assertNull((Object)root.getParentDomainName());
        if (allDomains.size() > 0) {
            Assert.assertTrue((boolean)root.hasChild());
        }
        for (Domain domain : allDomains) {
            this.checkDomain(domain, allDomains);
        }
    }

    @Test
    public void testListDomainChildren() {
        assert (this.domainAdminEnabled);
        Set allDomains = this.domainAdminClient.getDomainClient().listDomains(new ListDomainsOptions[0]);
        Domain root = (Domain)Iterables.find((Iterable)allDomains, this.withName("ROOT"));
        Set children = this.domainAdminClient.getDomainClient().listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((long)root.getId()).isRecursive(true)});
        Assert.assertEquals((int)(allDomains.size() - 1), (int)children.size());
        for (Domain domain : children) {
            this.checkDomain(domain, allDomains);
        }
    }

    private Predicate<Domain> withName(final String name) {
        return new Predicate<Domain>(){

            public boolean apply(@Nullable Domain domain) {
                return domain != null && domain.getName().equals(name);
            }
        };
    }

    private void checkDomain(Domain domain, Set<Domain> allDomains) {
        assert (domain.getId() > 0L) : domain;
        if (domain.getParentDomainName() != null) {
            Domain parent = (Domain)Iterables.find(allDomains, this.withName(domain.getParentDomainName()));
            Assert.assertEquals((long)parent.getId(), (long)domain.getParentDomainId());
            Assert.assertTrue((boolean)parent.hasChild());
        }
    }
}

