/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.easymock.classextension.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.features.AsyncJobClient;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BlockUntilJobCompletesAndReturnResultTest")
public class BlockUntilJobCompletesAndReturnResultTest {
    public void testApply() {
        long id = 1L;
        long jobId = 2L;
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysTrue();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        org.easymock.EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        org.easymock.EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(new AsyncCreateResponse(id, jobId))), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testJobDoesntCompleteThrowsIllegalStateException() {
        long id = 1L;
        long jobId = 2L;
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysFalse();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        org.easymock.EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        org.easymock.EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(new AsyncCreateResponse(id, jobId))), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }

    @Test(expectedExceptions={UncheckedExecutionException.class})
    public void testJobWithErrorThrowsUncheckedExecutionException() {
        long id = 1L;
        long jobId = 2L;
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        Predicate jobComplete = Predicates.alwaysTrue();
        AsyncJobClient jobClient = (AsyncJobClient)EasyMock.createMock(AsyncJobClient.class);
        org.easymock.EasyMock.expect((Object)client.getAsyncJobClient()).andReturn((Object)jobClient).atLeastOnce();
        org.easymock.EasyMock.expect((Object)jobClient.getAsyncJob(jobId)).andReturn((Object)AsyncJob.builder().id(jobId).error(new AsyncJobError(AsyncJobError.ErrorCode.INTERNAL_ERROR, "ERRROR")).result((Object)"foo").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{jobClient});
        Assert.assertEquals((String)((String)new BlockUntilJobCompletesAndReturnResult(client, jobComplete).apply(new AsyncCreateResponse(id, jobId))), (String)"foo");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{jobClient});
    }
}

