/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.collect.ImmutableSet;
import org.easymock.classextension.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.features.AddressClient;
import org.jclouds.cloudstack.functions.ReuseOrAssociateNewPublicIPAddress;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReuseOrAssociateNewPublicIPAddressTest {
    long networkId = 99L;
    long zoneId = 100L;
    PublicIPAddress address = PublicIPAddress.builder().id(200L).state(PublicIPAddress.State.ALLOCATED).associatedNetworkId(this.networkId).zoneId(this.zoneId).build();

    public void testReuseWorks() throws SecurityException, NoSuchMethodException {
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult = (BlockUntilJobCompletesAndReturnResult)EasyMock.createMock(BlockUntilJobCompletesAndReturnResult.class);
        AddressClient addressClient = (AddressClient)EasyMock.createMock(AddressClient.class);
        org.easymock.EasyMock.expect((Object)client.getAddressClient()).andReturn((Object)addressClient).atLeastOnce();
        org.easymock.EasyMock.expect((Object)addressClient.listPublicIPAddresses(new ListPublicIPAddressesOptions[]{ListPublicIPAddressesOptions.Builder.allocatedOnly((boolean)true).networkId(this.networkId)})).andReturn((Object)ImmutableSet.of((Object)this.address));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{blockUntilJobCompletesAndReturnResult});
        EasyMock.replay((Object[])new Object[]{addressClient});
        Assert.assertEquals((Object)new ReuseOrAssociateNewPublicIPAddress(client, blockUntilJobCompletesAndReturnResult).apply(Network.builder().id(this.networkId).zoneId(this.zoneId).build()), (Object)this.address);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{blockUntilJobCompletesAndReturnResult});
        EasyMock.verify((Object[])new Object[]{addressClient});
    }

    public void testAssociateWorks() throws SecurityException, NoSuchMethodException {
        CloudStackClient client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult = (BlockUntilJobCompletesAndReturnResult)EasyMock.createMock(BlockUntilJobCompletesAndReturnResult.class);
        AddressClient addressClient = (AddressClient)EasyMock.createMock(AddressClient.class);
        org.easymock.EasyMock.expect((Object)client.getAddressClient()).andReturn((Object)addressClient).atLeastOnce();
        org.easymock.EasyMock.expect((Object)addressClient.listPublicIPAddresses(new ListPublicIPAddressesOptions[]{ListPublicIPAddressesOptions.Builder.allocatedOnly((boolean)true).networkId(this.networkId)})).andReturn((Object)ImmutableSet.of());
        AsyncCreateResponse job = new AsyncCreateResponse(1L, 2L);
        org.easymock.EasyMock.expect((Object)addressClient.associateIPAddressInZone(this.zoneId, new AssociateIPAddressOptions[]{AssociateIPAddressOptions.Builder.networkId((long)this.networkId)})).andReturn((Object)job);
        org.easymock.EasyMock.expect((Object)blockUntilJobCompletesAndReturnResult.apply(job)).andReturn((Object)this.address);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{addressClient});
        EasyMock.replay((Object[])new Object[]{blockUntilJobCompletesAndReturnResult});
        Assert.assertEquals((Object)new ReuseOrAssociateNewPublicIPAddress(client, blockUntilJobCompletesAndReturnResult).apply(Network.builder().id(this.networkId).zoneId(this.zoneId).build()), (Object)this.address);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{addressClient});
        EasyMock.verify((Object[])new Object[]{blockUntilJobCompletesAndReturnResult});
    }
}

