/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.compute.config.CloudStackComputeServiceContextModule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.NATClientLiveTest;
import org.jclouds.cloudstack.features.VirtualMachineClientLiveTest;
import org.jclouds.cloudstack.functions.CreatePortForwardingRulesForIP;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="StaticNATVirtualMachineInNetworkLiveTest")
public class StaticNATVirtualMachineInNetworkLiveTest
extends NATClientLiveTest {
    private PublicIPAddress ip = null;
    private VirtualMachine vm;
    private IPForwardingRule rule;
    private Network network;
    private boolean networksDisabled;

    @Override
    @BeforeGroups(groups={"live"})
    public void setupClient() {
        super.setupClient();
        this.prefix = this.prefix + "nat";
        try {
            this.network = (Network)Iterables.find((Iterable)this.client.getNetworkClient().listNetworks(new ListNetworksOptions[0]), (Predicate)NetworkPredicates.supportsStaticNAT());
            Long defaultTemplate = this.imageId != null && !"".equals(this.imageId) ? new Long(this.imageId) : null;
            this.vm = VirtualMachineClientLiveTest.createVirtualMachineInNetwork(this.network, StaticNATVirtualMachineInNetworkLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.network.getZoneId()), this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
            if (this.vm.getPassword() != null && !this.loginCredentials.hasPasswordOption()) {
                this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
            }
        }
        catch (NoSuchElementException e) {
            this.networksDisabled = true;
        }
    }

    public void testCreateIPForwardingRule() throws Exception {
        if (this.networksDisabled) {
            return;
        }
        BlockUntilJobCompletesAndReturnResult blocker = new BlockUntilJobCompletesAndReturnResult(this.client, (Predicate)this.jobComplete);
        StaticNATVirtualMachineInNetwork fn = new StaticNATVirtualMachineInNetwork(this.client, this.reuseOrAssociate, this.network);
        CreatePortForwardingRulesForIP createPortForwardingRulesForIP = new CreatePortForwardingRulesForIP(this.client, blocker, CacheBuilder.newBuilder().build((CacheLoader)new CloudStackComputeServiceContextModule.GetIPForwardingRulesByVirtualMachine(this.client)));
        this.injector.injectMembers((Object)blocker);
        this.injector.injectMembers((Object)fn);
        this.injector.injectMembers((Object)createPortForwardingRulesForIP);
        this.ip = fn.apply(this.vm);
        createPortForwardingRulesForIP.apply(this.ip, (Iterable)ImmutableSet.of((Object)22));
        this.rule = (IPForwardingRule)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)this.client.getNATClient().getIPForwardingRulesForIPAddress(this.ip.getId()), (Predicate)new Predicate<IPForwardingRule>(){

            public boolean apply(@Nullable IPForwardingRule rule) {
                return rule != null && rule.getStartPort() == 22;
            }
        }));
        Assert.assertEquals((long)this.rule.getIPAddressId(), (long)this.ip.getId());
        Assert.assertEquals((long)this.rule.getVirtualMachineId(), (long)this.vm.getId());
        Assert.assertEquals((int)this.rule.getStartPort(), (int)22);
        Assert.assertEquals((String)this.rule.getProtocol(), (String)"tcp");
        this.checkRule(this.rule);
        IPSocket socket = new IPSocket(this.ip.getIPAddress(), 22);
        this.checkSSH(socket);
    }

    @Override
    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.rule != null) {
            this.client.getNATClient().deleteIPForwardingRule(this.rule.getId());
        }
        if (this.vm != null) {
            this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vm.getId()));
        }
        if (this.ip != null) {
            this.client.getAddressClient().disassociateIPAddress(this.ip.getId());
        }
        super.tearDown();
    }
}

