/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListPublicIPAddressesOptionsTest {
    public void testAllocatedOnly() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().allocatedOnly(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"allocatedonly"));
    }

    public void testAllocatedOnlyStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.allocatedOnly((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"allocatedonly"));
    }

    public void testVLANId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().VLANId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"vlanid"));
    }

    public void testVLANIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.VLANId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"vlanid"));
    }

    public void testNetworkId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().networkId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testNetworkIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.networkId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"networkid"));
    }

    public void testIPAddress() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().IPAddress("10.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"10.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"ipaddress"));
    }

    public void testIPAddressStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.IPAddress((String)"10.1.1.1");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"10.1.1.1"), (Collection)options.buildQueryParameters().get((Object)"ipaddress"));
    }

    public void testAccountInDomainId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().accountInDomain("adrian", 6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.accountInDomain((String)"adrian", (long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testZoneId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().zoneId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testZoneIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.zoneId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"zoneid"));
    }

    public void testUsingVirtualNetwork() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().usesVirtualNetwork(true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testUsingVirtualNetworkStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.usesVirtualNetwork((boolean)true);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"forvirtualnetwork"));
    }

    public void testId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().id(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testDomainId() {
        ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions().domainId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.id((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"id"));
    }

    public void testDomainIdStatic() {
        ListPublicIPAddressesOptions options = ListPublicIPAddressesOptions.Builder.domainId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }
}

