/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NetworkPredicatesTest {
    public void testHasLoadBalancerService() {
        Network network = Network.builder().id(204L).services((Set)ImmutableSet.of((Object)new NetworkService("Lb"))).build();
        assert (NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsStaticNATFindsWhenFirewallHasStaticNatFeature() {
        Network network = Network.builder().id(204L).services((Set)ImmutableSet.of((Object)new NetworkService("Firewall", (Map)ImmutableMap.of((Object)"StaticNat", (Object)"true")))).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testNoSupport() {
        Network network = Network.builder().id(204L).services((Set)ImmutableSet.of((Object)new NetworkService("Firewall", (Map)ImmutableMap.of()))).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (!NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsPortForwardingFindsWhenFirewallHasPortForwardingFeature() {
        Network network = Network.builder().id(204L).services((Set)ImmutableSet.of((Object)new NetworkService("Firewall", (Map)ImmutableMap.of((Object)"PortForwarding", (Object)"true")))).build();
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
        assert (!NetworkPredicates.supportsStaticNAT().apply((Object)network));
        assert (NetworkPredicates.supportsPortForwarding().apply((Object)network));
    }

    public void testSupportsPortForwardingAndStaticNATWhenFirewallHasFeatures() {
        Network network = Network.builder().id(204L).services((Set)ImmutableSet.of((Object)new NetworkService("Firewall", (Map)ImmutableMap.of((Object)"StaticNat", (Object)"true", (Object)"PortForwarding", (Object)"true")))).build();
        assert (Predicates.and((Predicate)NetworkPredicates.supportsPortForwarding(), (Predicate)NetworkPredicates.supportsStaticNAT()).apply((Object)network));
        assert (!NetworkPredicates.hasLoadBalancerService().apply((Object)network));
    }

    public void testDefaultNetworkInZone() {
        Network defaultInZone = Network.builder().isDefault(true).zoneId(42L).build();
        Network defaultNotInZone = Network.builder().isDefault(true).zoneId(200L).build();
        Network notDefaultInZone = Network.builder().isDefault(false).zoneId(42L).build();
        Network notDefaultNotInZone = Network.builder().isDefault(false).zoneId(200L).build();
        Predicate predicate = NetworkPredicates.defaultNetworkInZone((long)42L);
        Assert.assertTrue((boolean)predicate.apply((Object)defaultInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)defaultNotInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)notDefaultInZone));
        Assert.assertFalse((boolean)predicate.apply((Object)notDefaultNotInZone));
    }
}

