/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import org.jclouds.cloudstack.domain.Event;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.functions.ParseEventTypesFromHttpResponse;
import org.jclouds.cloudstack.options.ListEventsOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface EventAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listEventTypes"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseEventTypesFromHttpResponse.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<String>> listEventTypes();

    @GET
    @QueryParams(keys={"command"}, values={"listEvents"})
    @SelectJson(value="event")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Event>> listEvents(ListEventsOptions ... var1);
}

