/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.UnknownHostException;
import java.util.Set;
import org.jclouds.cloudstack.compute.functions.ServiceOfferingToHardwareTest;
import org.jclouds.cloudstack.compute.functions.TemplateToImageTest;
import org.jclouds.cloudstack.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.cloudstack.compute.functions.ZoneToLocationTest;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.parse.ListVirtualMachinesResponseTest;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VirtualMachineToNodeMetadataTest")
public class VirtualMachineToNodeMetadataTest {
    @Test
    public void testApplyWhereVirtualMachineWithIPForwardingRule() throws UnknownHostException {
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
        Supplier hardwareSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ServiceOfferingToHardwareTest.one, (Object)ServiceOfferingToHardwareTest.two));
        Supplier imageSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)TemplateToImageTest.one, (Object)TemplateToImageTest.two));
        VirtualMachineToNodeMetadata parser = new VirtualMachineToNodeMetadata(new VirtualMachineToNodeMetadata.FindLocationForVirtualMachine(locationSupplier), new VirtualMachineToNodeMetadata.FindHardwareForVirtualMachine(hardwareSupplier), new VirtualMachineToNodeMetadata.FindImageForVirtualMachine(imageSupplier), CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Set<IPForwardingRule>>(){

            public Set<IPForwardingRule> load(Long arg0) throws Exception {
                return ImmutableSet.of((Object)IPForwardingRule.builder().id(1234L).IPAddress("1.1.1.1").build());
            }
        }));
        VirtualMachine guest = (VirtualMachine)Iterables.get((Iterable)new ListVirtualMachinesResponseTest().expected(), (int)0);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((String)node.toString(), (String)new NodeMetadataBuilder().id("54").providerId("54").name("i-3-54-VM").group("i-3").location(ZoneToLocationTest.one).state(NodeState.PENDING).hostname("i-3-54-VM").privateAddresses((Iterable)ImmutableSet.of((Object)"10.1.1.18")).publicAddresses((Iterable)ImmutableSet.of((Object)"1.1.1.1")).hardware(ServiceOfferingToHardwareTest.one).imageId(TemplateToImageTest.one.getId()).operatingSystem(TemplateToImageTest.one.getOperatingSystem()).build().toString());
    }

    @Test
    public void testApplyWhereVirtualMachineWithNoPassword() throws UnknownHostException {
        Supplier locationSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ZoneToLocationTest.one, (Object)ZoneToLocationTest.two));
        Supplier hardwareSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)ServiceOfferingToHardwareTest.one, (Object)ServiceOfferingToHardwareTest.two));
        Supplier imageSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)TemplateToImageTest.one, (Object)TemplateToImageTest.two));
        VirtualMachineToNodeMetadata parser = new VirtualMachineToNodeMetadata(new VirtualMachineToNodeMetadata.FindLocationForVirtualMachine(locationSupplier), new VirtualMachineToNodeMetadata.FindHardwareForVirtualMachine(hardwareSupplier), new VirtualMachineToNodeMetadata.FindImageForVirtualMachine(imageSupplier), CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Set<IPForwardingRule>>(){

            public Set<IPForwardingRule> load(Long arg0) throws Exception {
                throw new ResourceNotFoundException("no ip forwarding rule for: " + arg0);
            }
        }));
        VirtualMachine guest = (VirtualMachine)Iterables.get((Iterable)new ListVirtualMachinesResponseTest().expected(), (int)0);
        NodeMetadata node = parser.apply(guest);
        Assert.assertEquals((String)node.toString(), (String)new NodeMetadataBuilder().id("54").providerId("54").name("i-3-54-VM").group("i-3").location(ZoneToLocationTest.one).state(NodeState.PENDING).hostname("i-3-54-VM").privateAddresses((Iterable)ImmutableSet.of((Object)"10.1.1.18")).hardware(ServiceOfferingToHardwareTest.one).imageId(TemplateToImageTest.one.getId()).operatingSystem(TemplateToImageTest.one.getOperatingSystem()).build().toString());
    }
}

