/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.features.GlobalDomainClient;
import org.jclouds.cloudstack.options.CreateDomainOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.jclouds.cloudstack.options.UpdateDomainOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalDomainClientLiveTest")
public class GlobalDomainClientLiveTest
extends BaseCloudStackClientLiveTest {
    private GlobalDomainClient domainClient;
    private Domain rootDomain;

    @BeforeMethod
    public void before() {
        this.domainClient = this.globalAdminClient.getDomainClient();
        this.rootDomain = (Domain)Iterables.find((Iterable)this.domainClient.listDomains(new ListDomainsOptions[0]), (Predicate)new Predicate<Domain>(){

            public boolean apply(@Nullable Domain domain) {
                return domain != null && domain.getName().equals("ROOT");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUpdateDeleteDomain() {
        assert (this.globalAdminEnabled);
        Domain domain = null;
        try {
            domain = this.domainClient.createDomain(this.prefix + "-domain", new CreateDomainOptions[0]);
            this.checkDomain(domain, this.rootDomain, this.prefix + "-domain");
            Domain updated = this.domainClient.updateDomain(domain.getId(), new UpdateDomainOptions[]{UpdateDomainOptions.Builder.name((String)(this.prefix + "-domain-2"))});
            this.checkDomain(updated, this.rootDomain, this.prefix + "-domain-2");
            Assert.assertEquals((long)updated.getId(), (long)domain.getId());
        }
        finally {
            if (domain != null) {
                this.domainClient.deleteDomainAndAttachedResources(domain.getId());
            }
        }
        Assert.assertNull((Object)this.domainClient.getDomainById(domain.getId()));
    }

    private void checkDomain(Domain domain, Domain rootDomain, String expectedName) {
        Assert.assertEquals((long)domain.getParentDomainId(), (long)rootDomain.getId());
        Assert.assertEquals((String)domain.getName(), (String)expectedName);
        Assert.assertEquals((String)domain.getParentDomainName(), (String)rootDomain.getName());
    }
}

