/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.StorageType;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListDiskOfferingsOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.ListServiceOfferingsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="OfferingClientLiveTest")
public class OfferingClientLiveTest
extends BaseCloudStackClientLiveTest {
    public void testListDiskOfferings() throws Exception {
        Set response = this.client.getOfferingClient().listDiskOfferings(new ListDiskOfferingsOptions[0]);
        assert (null != response);
        long offeringCount = response.size();
        Assert.assertTrue((offeringCount >= 0L ? 1 : 0) != 0);
        for (DiskOffering offering : response) {
            try {
                DiskOffering newDetails = (DiskOffering)Iterables.getOnlyElement((Iterable)this.client.getOfferingClient().listDiskOfferings(new ListDiskOfferingsOptions[]{ListDiskOfferingsOptions.Builder.id((long)offering.getId())}));
                Assert.assertEquals((Object)offering, (Object)newDetails);
                Assert.assertEquals((Object)offering, (Object)this.client.getOfferingClient().getDiskOffering(offering.getId()));
                assert (offering.getId() > 0L) : offering;
                assert (offering.getName() != null) : offering;
                assert (offering.getCreated() != null) : offering;
                assert (offering.getDisplayText() != null) : offering;
                assert (offering.getDiskSize() > 0 || offering.getDiskSize() == 0 && offering.isCustomized()) : offering;
                assert (offering.getTags() != null) : offering;
            }
            catch (NoSuchElementException e) {
                Assert.assertTrue(("2.2.8".equals(this.apiVersion) || "2.2.12".equals(this.apiVersion) ? 1 : 0) != 0);
            }
        }
    }

    public void testListServiceOfferings() throws Exception {
        Set response = this.client.getOfferingClient().listServiceOfferings(new ListServiceOfferingsOptions[0]);
        assert (null != response);
        long offeringCount = response.size();
        Assert.assertTrue((offeringCount >= 0L ? 1 : 0) != 0);
        for (ServiceOffering offering : response) {
            ServiceOffering newDetails = (ServiceOffering)Iterables.getOnlyElement((Iterable)this.client.getOfferingClient().listServiceOfferings(new ListServiceOfferingsOptions[]{ListServiceOfferingsOptions.Builder.id((long)offering.getId())}));
            Assert.assertEquals((Object)offering, (Object)newDetails);
            assert (offering.getId() > 0L) : offering;
            assert (offering.getName() != null) : offering;
            assert (offering.getDisplayText() != null) : offering;
            assert (offering.getCpuNumber() > 0) : offering;
            assert (offering.getCpuSpeed() > 0) : offering;
            assert (offering.getMemory() > 0) : offering;
            assert (offering.getStorageType() != null && StorageType.UNRECOGNIZED != offering.getStorageType()) : offering;
            assert (offering.getTags() != null) : offering;
        }
    }

    public void testListNetworkOfferings() throws Exception {
        Set response = this.client.getOfferingClient().listNetworkOfferings(new ListNetworkOfferingsOptions[0]);
        assert (null != response);
        long offeringCount = response.size();
        Assert.assertTrue((offeringCount >= 0L ? 1 : 0) != 0);
        for (NetworkOffering offering : response) {
            NetworkOffering newDetails = (NetworkOffering)Iterables.getOnlyElement((Iterable)this.client.getOfferingClient().listNetworkOfferings(new ListNetworkOfferingsOptions[]{ListNetworkOfferingsOptions.Builder.id((long)offering.getId())}));
            Assert.assertEquals((Object)offering, (Object)newDetails);
            Assert.assertEquals((Object)offering, (Object)this.client.getOfferingClient().getNetworkOffering(offering.getId()));
            assert (offering.getId() > 0L) : offering;
            assert (offering.getName() != null) : offering;
            assert (offering.getDisplayText() != null) : offering;
            assert (offering.getMaxConnections() == null || offering.getMaxConnections() > 0) : offering;
            assert (offering.getTrafficType() != null && TrafficType.UNRECOGNIZED != offering.getTrafficType()) : offering;
            assert (offering.getTags() != null) : offering;
        }
    }
}

