/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Set;
import org.jclouds.cloudstack.config.CloudStackParserModule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListPortForwardingRulesResponseTest
extends BaseSetParserTest<PortForwardingRule> {
    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new CloudStackParserModule(), new GsonModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
                super.configure();
            }
        }});
    }

    public String resource() {
        return "/listportforwardingrulesresponse.json";
    }

    @SelectJson(value="portforwardingrule")
    public Set<PortForwardingRule> expected() {
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        return ImmutableSet.of((Object)PortForwardingRule.builder().id(15L).privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId(3L).virtualMachineName("i-3-3-VM").IPAddressId(3L).IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).build(), (Object)PortForwardingRule.builder().id(18L).privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(22).virtualMachineId(89L).virtualMachineName("i-3-89-VM").IPAddressId(34L).IPAddress("72.52.126.63").state(PortForwardingRule.State.ACTIVE).build());
    }
}

