/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

@Singleton
public class TemplateToOperatingSystem
implements Function<Template, OperatingSystem> {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile(".* ([0-9.]+) ?\\(.*");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<Long, OSType>> osTypes;
    private final Supplier<Map<Long, String>> osCategories;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public TemplateToOperatingSystem(@Memoized Supplier<Map<Long, OSType>> osTypes, @Memoized Supplier<Map<Long, String>> osCategories, Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osTypes = (Supplier)Preconditions.checkNotNull(osTypes, (Object)"osTypes");
        this.osCategories = (Supplier)Preconditions.checkNotNull(osCategories, (Object)"osCategories");
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"osVersionMap");
    }

    public OperatingSystem apply(Template from) {
        OperatingSystem.Builder builder = OperatingSystem.builder().description(from.getOSType());
        OSType type = (OSType)((Map)this.osTypes.get()).get(from.getOSTypeId());
        if (type == null) {
            this.logger.warn("type for template %s not found in %s", new Object[]{from, this.osTypes.get()});
            return builder.build();
        }
        builder.description(type.getDescription());
        builder.is64Bit(type.getDescription().indexOf("64-bit") != -1);
        String osCategory = (String)((Map)this.osCategories.get()).get(type.getOSCategoryId());
        if (osCategory == null) {
            this.logger.warn("category for OSType %s not found in %s", new Object[]{type, this.osCategories.get()});
            return builder.build();
        }
        builder.name(osCategory);
        OsFamily family = OsFamily.fromValue((String)osCategory.toLowerCase());
        builder.family(family);
        Matcher matcher = DEFAULT_PATTERN.matcher(type.getDescription());
        if (matcher.find()) {
            builder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)matcher.group(1), this.osVersionMap));
        }
        return builder.build();
    }
}

