/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.DomainDomainAsyncClient;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.CreateDomainOptions;
import org.jclouds.cloudstack.options.UpdateDomainOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalDomainAsyncClient
extends DomainDomainAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"createDomain"})
    @SelectJson(value="domain")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Domain> createDomain(@QueryParam(value="name") String var1, CreateDomainOptions ... var2);

    @GET
    @QueryParams(keys={"command"}, values={"updateDomain"})
    @SelectJson(value="domain")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Domain> updateDomain(@QueryParam(value="id") long var1, UpdateDomainOptions ... var3);

    @GET
    @QueryParams(keys={"command", "cleanup"}, values={"deleteDomain", "false"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteOnlyDomain(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command", "cleanup"}, values={"deleteDomain", "true"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteDomainAndAttachedResources(@QueryParam(value="id") long var1);
}

