/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.binders.BindAccountSecurityGroupPairsToIndexedQueryParams;
import org.jclouds.cloudstack.binders.BindCIDRsToCommaDelimitedQueryParam;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface SecurityGroupAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listSecurityGroups"})
    @SelectJson(value="securitygroup")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<SecurityGroup>> listSecurityGroups(ListSecurityGroupsOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"listSecurityGroups"})
    @SelectJson(value="securitygroup")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<SecurityGroup> getSecurityGroup(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createSecurityGroup"})
    @SelectJson(value="securitygroup")
    @Consumes(value={"application/json"})
    public ListenableFuture<SecurityGroup> createSecurityGroup(@QueryParam(value="name") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"authorizeSecurityGroupIngress"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> authorizeIngressPortsToCIDRs(@QueryParam(value="securitygroupid") long var1, @QueryParam(value="protocol") String var3, @QueryParam(value="startport") int var4, @QueryParam(value="endport") int var5, @BinderParam(value=BindCIDRsToCommaDelimitedQueryParam.class) Iterable<String> var6, AccountInDomainOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"authorizeSecurityGroupIngress"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> authorizeIngressPortsToSecurityGroups(@QueryParam(value="securitygroupid") long var1, @QueryParam(value="protocol") String var3, @QueryParam(value="startport") int var4, @QueryParam(value="endport") int var5, @BinderParam(value=BindAccountSecurityGroupPairsToIndexedQueryParams.class) Multimap<String, String> var6, AccountInDomainOptions ... var7);

    @GET
    @QueryParams(keys={"command", "protocol"}, values={"authorizeSecurityGroupIngress", "ICMP"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> authorizeIngressICMPToCIDRs(@QueryParam(value="securitygroupid") long var1, @QueryParam(value="icmpcode") int var3, @QueryParam(value="icmptype") int var4, @BinderParam(value=BindCIDRsToCommaDelimitedQueryParam.class) Iterable<String> var5, AccountInDomainOptions ... var6);

    @GET
    @QueryParams(keys={"command", "protocol"}, values={"authorizeSecurityGroupIngress", "ICMP"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> authorizeIngressICMPToSecurityGroups(@QueryParam(value="securitygroupid") long var1, @QueryParam(value="icmpcode") int var3, @QueryParam(value="icmptype") int var4, @BinderParam(value=BindAccountSecurityGroupPairsToIndexedQueryParams.class) Multimap<String, String> var5, AccountInDomainOptions ... var6);

    @GET
    @QueryParams(keys={"command"}, values={"revokeSecurityGroupIngress"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> revokeIngressRule(@QueryParam(value="id") long var1, AccountInDomainOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteSecurityGroup"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSecurityGroup(@QueryParam(value="id") long var1);
}

