/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.jclouds.cloudstack.compute.functions.TemplateToOperatingSystem;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.parse.ListOSCategoriesResponseTest;
import org.jclouds.cloudstack.parse.ListOSTypesResponseTest;
import org.jclouds.cloudstack.parse.ListTemplatesResponseTest;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class TemplateToOperatingSystemTest {
    static Map<Long, OSType> ostypes = Maps.uniqueIndex((Iterable)new ListOSTypesResponseTest().expected(), (Function)new Function<OSType, Long>(){

        public Long apply(OSType arg0) {
            return arg0.getId();
        }
    });
    static TemplateToOperatingSystem function = new TemplateToOperatingSystem(Suppliers.ofInstance(ostypes), Suppliers.ofInstance((Object)new ListOSCategoriesResponseTest().expected()), new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class)));
    static OperatingSystem one = OperatingSystem.builder().name("CentOS").family(OsFamily.CENTOS).is64Bit(false).version("5.3").description("CentOS 5.3 (32-bit)").build();
    static OperatingSystem two = OperatingSystem.builder().name("CentOS").family(OsFamily.CENTOS).is64Bit(true).version("5.5").description("CentOS 5.5 (64-bit)").build();
    static OperatingSystem three = OperatingSystem.builder().name("Windows").family(OsFamily.WINDOWS).is64Bit(false).version("7").description("Windows 7 (32-bit)").build();
    static OperatingSystem four = OperatingSystem.builder().name("CentOS").family(OsFamily.CENTOS).is64Bit(true).version("5.3").description("CentOS 5.3 (64-bit)").build();
    static OperatingSystem five = OperatingSystem.builder().name("CentOS").family(OsFamily.CENTOS).is64Bit(true).version("5.4").description("CentOS 5.4 (64-bit)").build();

    @Test
    public void test() {
        ImmutableSet expected = ImmutableSet.of((Object)one, (Object)two, (Object)three, (Object)four, (Object)five);
        Object offerings = new ListTemplatesResponseTest().expected();
        Iterable profiles = Iterables.transform((Iterable)offerings, (Function)function);
        AssertJUnit.assertEquals((String)profiles.toString(), (String)expected.toString());
    }
}

