/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import org.jclouds.cloudstack.domain.Capacity;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListCapacityOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalCapacityClientLiveTest")
public class GlobalCapacityClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListCapacity() throws Exception {
        Assert.assertTrue((boolean)this.globalAdminEnabled, (String)"Test cannot run without global admin identity and credentials");
        Set response = this.globalAdminClient.getCapacityClient().listCapacity(new ListCapacityOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        int count = 0;
        for (Capacity capacity : response) {
            Assert.assertTrue((capacity.getCapacityTotal() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((capacity.getCapacityUsed() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((capacity.getPercentUsed() >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((capacity.getType() != Capacity.Type.UNRECOGNIZED ? 1 : 0) != 0);
            Assert.assertNotNull((Object)capacity.getZoneName());
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0, (String)"No capacities were returned, so I couldn't test");
    }
}

