/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateSnapshotOptions;
import org.jclouds.cloudstack.options.ListSnapshotsOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateCallable;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.Retryables;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SnapshotClientLiveTest")
public class SnapshotClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Resource
    Logger logger = Logger.NULL;

    public void testListSnapshots() {
        Set snapshots = this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[0]);
        AssertJUnit.assertNotNull((Object)snapshots);
        AssertJUnit.assertFalse((boolean)snapshots.isEmpty());
        for (Snapshot snapshot : snapshots) {
            this.checkSnapshot(snapshot);
        }
    }

    public void testListSnapshotsById() {
        Iterable snapshotIds = Iterables.transform((Iterable)this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[0]), (Function)new Function<Snapshot, Long>(){

            public Long apply(Snapshot input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)snapshotIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)snapshotIds));
        for (Long id : snapshotIds) {
            Set found = this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[]{ListSnapshotsOptions.Builder.id((long)id)});
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)1, (int)found.size());
            Snapshot snapshot = (Snapshot)Iterables.getOnlyElement((Iterable)found);
            AssertJUnit.assertEquals((long)id, (long)snapshot.getId());
            this.checkSnapshot(snapshot);
        }
    }

    public void testListSnapshotsNonexistantId() {
        Set found = this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[]{ListSnapshotsOptions.Builder.id((long)-1L)});
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertTrue((boolean)found.isEmpty());
    }

    public void testGetSnapshotById() {
        Iterable snapshotIds = Iterables.transform((Iterable)this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[0]), (Function)new Function<Snapshot, Long>(){

            public Long apply(Snapshot input) {
                return input.getId();
            }
        });
        AssertJUnit.assertNotNull((Object)snapshotIds);
        AssertJUnit.assertFalse((boolean)Iterables.isEmpty((Iterable)snapshotIds));
        for (Long id : snapshotIds) {
            Snapshot found = this.client.getSnapshotClient().getSnapshot(id.longValue());
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((long)id, (long)found.getId());
            this.checkSnapshot(found);
        }
    }

    public void testGetSnapshotNonexistantId() {
        Snapshot found = this.client.getSnapshotClient().getSnapshot(-1L);
        AssertJUnit.assertNull((Object)found);
    }

    protected Volume getPreferredVolume() {
        for (Volume candidate : this.client.getVolumeClient().listVolumes(new ListVolumesOptions[0])) {
            if (candidate.getState() != Volume.State.READY) continue;
            return candidate;
        }
        throw new AssertionError((Object)"No suitable Volume found.");
    }

    public void testCreateSnapshotFromVolume() {
        final Volume volume = this.getPreferredVolume();
        Snapshot snapshot = (Snapshot)Retryables.retryGettingResultOrFailing((PredicateWithResult)new PredicateCallable<Snapshot>(){

            public Snapshot call() {
                SnapshotClientLiveTest.this.logger.info("creating snapshot from volume %s", new Object[]{volume});
                AsyncCreateResponse job = SnapshotClientLiveTest.this.client.getSnapshotClient().createSnapshot(volume.getId(), new CreateSnapshotOptions[0]);
                AssertJUnit.assertTrue((boolean)SnapshotClientLiveTest.this.jobComplete.apply((Object)job.getJobId()));
                return SnapshotClientLiveTest.this.findSnapshotWithId(job.getId());
            }

            protected void onFailure() {
                SnapshotClientLiveTest.this.logger.info("failed creating snapshot (retrying): %s", new Object[]{this.getLastFailure()});
            }
        }, null, (long)60000L, (String)"failed to create snapshot");
        this.logger.info("created snapshot %s from volume %s", new Object[]{snapshot, volume});
        this.checkSnapshot(snapshot);
        this.client.getSnapshotClient().deleteSnapshot(snapshot.getId());
    }

    private void checkSnapshot(Snapshot snapshot) {
        AssertJUnit.assertNotNull((Object)snapshot.getId());
        AssertJUnit.assertNotNull((Object)snapshot.getName());
        AssertJUnit.assertNotSame((Object)Snapshot.Type.UNRECOGNIZED, (Object)snapshot.getSnapshotType());
    }

    private Snapshot findSnapshotWithId(final long id) {
        return (Snapshot)Iterables.find((Iterable)this.client.getSnapshotClient().listSnapshots(new ListSnapshotsOptions[0]), (Predicate)new Predicate<Snapshot>(){

            public boolean apply(Snapshot arg0) {
                return arg0.getId() == id;
            }
        });
    }
}

