/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.sun.jersey.api.uri.UriBuilderImpl;
import com.sun.jersey.api.uri.UriComponent;
import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.filters.ReEncodeQueryWithDefaultURLEncoder;
import org.jclouds.http.HttpRequest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ReEncodeQueryWithJavaNetURLEncoder")
public class ReEncodeQueryWithJavaNetURLEncoderTest {
    @Test
    public void testReUrlEncode() {
        String input = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCc903twxU2zcQnIJdXv61RwZNZW94uId9qz08fgsBJsCOnHNIC4+L9kDOA2IHV9cUfEDBm1Be5TbpadWwSbS/05E+FARH2/MCO932UgcKUq5PGymS0249fLCBPci5zoLiG5vIym+1ij1hL/nHvkK99NIwe7io+Lmp9OcF3PTsm3Rgh5T09cRHGX9horp0VoAVa9vKJx6C1/IEHVnG8p0YPPa1lmemvx5kNBEiyoNQNYa34EiFkcJfP6rqNgvY8h/j4nE9SXoUCC/g6frhMFMOL0tzYqvz0Lczqm1Oh4RnSn3O9X4R934p28qqAobe337hmlLUdb6H5zuf+NwCh0HdZ";
        String defaultJcloudsEncodedRequest = "http://localhost?foo=" + Strings2.urlEncode((String)input, (char[])new char[0]);
        String defaultEncodedRequest = "http://localhost?foo=" + URLEncoder.encode(input);
        assert (!defaultJcloudsEncodedRequest.equals(defaultEncodedRequest));
        HttpRequest request = new HttpRequest("GET", URI.create("http://localhost?foo=" + Strings2.urlEncode((String)input, (char[])new char[0])));
        request = ((ReEncodeQueryWithDefaultURLEncoder)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(UriBuilder.class).to(UriBuilderImpl.class);
            }
        }}).getInstance(ReEncodeQueryWithDefaultURLEncoder.class)).filter(request);
        Assert.assertEquals((String)request.getEndpoint().toASCIIString(), (String)("http://localhost?foo=" + UriComponent.encode((String)input, (UriComponent.Type)UriComponent.Type.QUERY_PARAM)));
    }
}

