/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.cloudstack.options.ListAsyncJobsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAsyncJobsOptionsTest {
    public void testAccountInDomainId() {
        ListAsyncJobsOptions options = new ListAsyncJobsOptions().accountInDomain("adrian", 6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testAccountInDomainIdStatic() {
        ListAsyncJobsOptions options = ListAsyncJobsOptions.Builder.accountInDomain((String)"adrian", (long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"adrian"), (Collection)options.buildQueryParameters().get((Object)"account"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testStartDate() {
        ListAsyncJobsOptions options = new ListAsyncJobsOptions().startDate(new Date(100000L));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1970-01-01T00:01:40Z"), (Collection)options.buildQueryParameters().get((Object)"startdate"));
    }

    public void testDomainId() {
        ListAsyncJobsOptions options = new ListAsyncJobsOptions().domainId(6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }

    public void testStartDateStatic() {
        ListAsyncJobsOptions options = ListAsyncJobsOptions.Builder.startDate((Date)new Date(100000L));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1970-01-01T00:01:40Z"), (Collection)options.buildQueryParameters().get((Object)"startdate"));
    }

    public void testDomainIdStatic() {
        ListAsyncJobsOptions options = ListAsyncJobsOptions.Builder.domainId((long)6L);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"6"), (Collection)options.buildQueryParameters().get((Object)"domainid"));
    }
}

