/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineClient;
import org.jclouds.cloudstack.predicates.VirtualMachineDestroyed;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="VirtualMachineDestroyedTest")
public class VirtualMachineDestroyedTest {
    CloudStackClient client;
    VirtualMachineClient virtualMachineClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        this.virtualMachineClient = (VirtualMachineClient)EasyMock.createMock(VirtualMachineClient.class);
        EasyMock.expect((Object)this.client.getVirtualMachineClient()).andReturn((Object)this.virtualMachineClient);
    }

    @Test
    public void testIsDestroyed() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id(229L).state(VirtualMachine.State.DESTROYED).build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertTrue((boolean)new VirtualMachineDestroyed(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }

    @Test
    public void testStillRunning() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id(229L).state(VirtualMachine.State.RUNNING).build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertFalse((boolean)new VirtualMachineDestroyed(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }
}

