/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.Volume;

public class Snapshot
implements Comparable<Snapshot> {
    private long id;
    private String account;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="intervaltype")
    private Interval interval;
    @SerializedName(value="jobid")
    private long jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String name;
    @SerializedName(value="snapshottype")
    private Type snapshotType;
    private State state;
    @SerializedName(value="volumeid")
    private long volumeId;
    @SerializedName(value="volumename")
    private String volumeName;
    @SerializedName(value="volumetype")
    private Volume.Type volumeType;

    public static Builder builder() {
        return new Builder();
    }

    public Snapshot(long id, String account, Date created, String domain, long domainId, Interval interval, long jobId, String jobStatus, String name, Type snapshotType, State state, long volumeId, String volumeName, Volume.Type volumeType) {
        this.id = id;
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.interval = interval;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.snapshotType = snapshotType;
        this.state = state;
        this.volumeId = volumeId;
        this.volumeName = volumeName;
        this.volumeType = volumeType;
    }

    Snapshot() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getName() {
        return this.name;
    }

    public Type getSnapshotType() {
        return this.snapshotType;
    }

    public State getState() {
        return this.state;
    }

    public long getVolumeId() {
        return this.volumeId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public Volume.Type getVolumeType() {
        return this.volumeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeId, (Object)that.volumeId)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.interval), (Object)((Object)that.interval))) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.snapshotType), (Object)((Object)that.snapshotType))) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeName, (Object)that.volumeName)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.volumeType), (Object)((Object)that.volumeType));
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (int)(this.jobId ^ this.jobId >>> 32);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.snapshotType != null ? this.snapshotType.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (int)(this.volumeId ^ this.volumeId >>> 32);
        result = 31 * result + (this.volumeName != null ? this.volumeName.hashCode() : 0);
        result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Snapshot{id=" + this.id + ", account='" + this.account + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", interval=" + (Object)((Object)this.interval) + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", name='" + this.name + '\'' + ", snapshotType=" + (Object)((Object)this.snapshotType) + ", state=" + (Object)((Object)this.state) + ", volumeId=" + this.volumeId + ", volumeName='" + this.volumeName + '\'' + ", volumeType=" + (Object)((Object)this.volumeType) + '}';
    }

    @Override
    public int compareTo(Snapshot other) {
        return new Long(this.id).compareTo(other.getId());
    }

    public static enum Interval {
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        template,
        none,
        UNRECOGNIZED;


        public static Interval fromValue(String type) {
            try {
                return Interval.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        MANUAL,
        RECURRING,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        BACKED_UP,
        CREATING,
        BACKING_UP,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String account;
        private Date created;
        private String domain;
        private long domainId;
        private Interval interval;
        private long jobId;
        private String jobStatus;
        private String name;
        private Type snapshotType;
        private State state;
        private long volumeId;
        private String volumeName;
        private Volume.Type volumeType;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder jobId(long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder snapshotType(Type snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder volumeType(Volume.Type volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this.id, this.account, this.created, this.domain, this.domainId, this.interval, this.jobId, this.jobStatus, this.name, this.snapshotType, this.state, this.volumeId, this.volumeName, this.volumeType);
        }
    }
}

