/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateExtraction;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;

@Singleton
public class ParseTypedAsyncJob
implements Function<AsyncJob<Map<String, JsonBall>>, AsyncJob<?>> {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.cloudstack.jobresult-type-map")
    @VisibleForTesting
    Map<String, Class<?>> typeMap = ImmutableMap.builder().put((Object)"user", User.class).put((Object)"account", Account.class).put((Object)"securitygroup", SecurityGroup.class).put((Object)"portforwardingrule", PortForwardingRule.class).put((Object)"ipforwardingrule", IPForwardingRule.class).put((Object)"firewallrule", FirewallRule.class).put((Object)"network", Network.class).put((Object)"ipaddress", PublicIPAddress.class).put((Object)"virtualmachine", VirtualMachine.class).put((Object)"loadbalancer", LoadBalancerRule.class).put((Object)"snapshot", Snapshot.class).put((Object)"template", Template.class).put((Object)"volume", Volume.class).build();
    private final Json json;

    @Inject
    public ParseTypedAsyncJob(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public AsyncJob<?> apply(AsyncJob<Map<String, JsonBall>> toParse) {
        AsyncJob<Map<String, JsonBall>> result = toParse;
        if (toParse.getResult() != null) {
            if (toParse.getResult().size() == 1) {
                AsyncJob.Builder<Map<String, JsonBall>> builder = AsyncJob.Builder.fromAsyncJobUntyped(toParse);
                if (toParse.getResult().containsKey("success")) {
                    builder.result(null);
                } else {
                    Map.Entry entry = (Map.Entry)Iterables.get(toParse.getResult().entrySet(), (int)0);
                    if ("template".equals(entry.getKey())) {
                        Template template = (Template)this.json.fromJson(((JsonBall)entry.getValue()).toString(), Template.class);
                        TemplateExtraction templateExtraction = (TemplateExtraction)this.json.fromJson(((JsonBall)entry.getValue()).toString(), TemplateExtraction.class);
                        boolean isTemplate = Strings.isNullOrEmpty((String)templateExtraction.getState());
                        builder.result((Map<String, JsonBall>)((Object)(isTemplate ? template : templateExtraction)));
                    } else if (this.typeMap.containsKey(entry.getKey())) {
                        builder.result((Map<String, JsonBall>)this.json.fromJson(((JsonBall)entry.getValue()).toString(), this.typeMap.get(entry.getKey())));
                    } else {
                        this.logger.warn("type key %s not configured.  please override default for Map<String, Class<?>> bound to name jclouds.cloudstack.jobresult-type-map", new Object[]{entry.getKey()});
                        builder.result((Map<String, JsonBall>)((Object)((JsonBall)entry.getValue()).toString()));
                    }
                }
                result = builder.build();
            } else if (toParse.getResult().containsKey("errorcode")) {
                AsyncJob.Builder<Map<String, JsonBall>> builder = AsyncJob.Builder.fromAsyncJobUntyped(toParse);
                builder.result(null);
                builder.error(new AsyncJobError(AsyncJobError.ErrorCode.fromValue(toParse.getResult().get("errorcode").toString()), toParse.getResult().containsKey("errortext") ? toParse.getResult().get("errortext").toString().replace("\"", "") : null));
                result = builder.build();
            } else if (toParse.getResult().size() > 1) {
                this.logger.warn("unexpected size of async job result; expecting a map with a single element", new Object[]{toParse.getResult()});
            }
        }
        return result;
    }
}

