/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.features.VirtualMachineClientLiveTest;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.cloudstack.predicates.NetworkPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="FirewallClientLiveTest")
public class FirewallClientLiveTest
extends BaseCloudStackClientLiveTest {
    private PublicIPAddress ip = null;
    private VirtualMachine vm;
    private FirewallRule firewallRule;
    private PortForwardingRule portForwardingRule;
    private Network network;
    private boolean networksDisabled;

    @Override
    @BeforeGroups(groups={"live"})
    public void setupClient() {
        super.setupClient();
        this.prefix = this.prefix + "rule";
        try {
            this.network = (Network)Iterables.find((Iterable)this.client.getNetworkClient().listNetworks(new ListNetworksOptions[0]), (Predicate)Predicates.and((Predicate)NetworkPredicates.supportsPortForwarding(), (Predicate)new Predicate<Network>(){

                public boolean apply(@Nullable Network network) {
                    return network.isDefault() && !network.isSecurityGroupEnabled() && network.getAccount().equals(FirewallClientLiveTest.this.user.getAccount());
                }
            }));
            Long defaultTemplate = this.imageId != null && !"".equals(this.imageId) ? new Long(this.imageId) : null;
            this.vm = VirtualMachineClientLiveTest.createVirtualMachineInNetwork(this.network, FirewallClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, this.client, this.network.getZoneId()), this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
            if (this.vm.getPassword() != null && !this.loginCredentials.hasPasswordOption()) {
                this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
            }
        }
        catch (NoSuchElementException e) {
            this.networksDisabled = true;
        }
    }

    public void testCreatePortForwardingRule() throws Exception {
        if (this.networksDisabled) {
            return;
        }
        while (this.portForwardingRule == null) {
            this.ip = this.reuseOrAssociate.apply(this.network);
            try {
                AsyncCreateResponse job = this.client.getFirewallClient().createPortForwardingRuleForVirtualMachine(this.ip.getId(), PortForwardingRule.Protocol.TCP, 22, this.vm.getId(), 22);
                Assert.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
                this.portForwardingRule = this.client.getFirewallClient().getPortForwardingRule(job.getId());
            }
            catch (IllegalStateException e) {
                Logger.CONSOLE.error("Failed while trying to allocate ip: " + e, new Object[0]);
            }
        }
        Assert.assertEquals((long)this.portForwardingRule.getIPAddressId(), (long)this.ip.getId());
        Assert.assertEquals((long)this.portForwardingRule.getVirtualMachineId(), (long)this.vm.getId());
        Assert.assertEquals((int)this.portForwardingRule.getPublicPort(), (int)22);
        Assert.assertEquals((Object)this.portForwardingRule.getProtocol(), (Object)PortForwardingRule.Protocol.TCP);
        this.checkPortForwardingRule(this.portForwardingRule);
        this.checkSSH(new IPSocket(this.ip.getIPAddress(), 22));
    }

    @Test(dependsOnMethods={"testCreatePortForwardingRule"})
    public void testListPortForwardingRules() throws Exception {
        Set response = this.client.getFirewallClient().listPortForwardingRules(new ListPortForwardingRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (PortForwardingRule rule : response) {
            this.checkPortForwardingRule(rule);
        }
    }

    @Test(dependsOnMethods={"testCreatePortForwardingRule"})
    public void testCreateFirewallRule() {
        if (this.networksDisabled) {
            return;
        }
        AsyncCreateResponse job = this.client.getFirewallClient().createFirewallRuleForIpAndProtocol(this.ip.getId(), FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[]{CreateFirewallRuleOptions.Builder.startPort((int)30).endPort(35)});
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job.getJobId()));
        this.firewallRule = this.client.getFirewallClient().getFirewallRule(job.getId());
        Assert.assertEquals((int)this.firewallRule.getStartPort(), (int)30);
        Assert.assertEquals((int)this.firewallRule.getEndPort(), (int)35);
        Assert.assertEquals((Object)this.firewallRule.getProtocol(), (Object)FirewallRule.Protocol.TCP);
        this.checkFirewallRule(this.firewallRule);
    }

    @Test(dependsOnMethods={"testCreateFirewallRule"})
    public void testListFirewallRules() {
        Set rules = this.client.getFirewallClient().listFirewallRules(new ListFirewallRulesOptions[0]);
        assert (rules != null);
        Assert.assertTrue((rules.size() > 0 ? 1 : 0) != 0);
        for (FirewallRule rule : rules) {
            this.checkFirewallRule(rule);
        }
    }

    @Override
    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.firewallRule != null) {
            this.client.getFirewallClient().deleteFirewallRule(this.firewallRule.getId());
        }
        if (this.portForwardingRule != null) {
            this.client.getFirewallClient().deletePortForwardingRule(this.portForwardingRule.getId());
        }
        if (this.vm != null) {
            this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vm.getId()));
        }
        if (this.ip != null) {
            this.client.getAddressClient().disassociateIPAddress(this.ip.getId());
        }
        super.tearDown();
    }

    protected void checkFirewallRule(FirewallRule rule) {
        Assert.assertEquals((Object)rule, (Object)this.client.getFirewallClient().getFirewallRule(rule.getId()));
        assert (rule.getId() > 0L) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getEndPort() >= rule.getStartPort()) : rule;
        assert (rule.getProtocol() != null);
    }

    protected void checkPortForwardingRule(PortForwardingRule rule) {
        Assert.assertEquals((Object)rule, (Object)this.client.getFirewallClient().getPortForwardingRule(rule.getId()));
        assert (rule.getId() > 0L) : rule;
        assert (rule.getIPAddress() != null) : rule;
        assert (rule.getIPAddressId() > 0L) : rule;
        assert (rule.getPrivatePort() > 0) : rule;
        assert (rule.getProtocol() != null) : rule;
        assert (rule.getPublicPort() > 0) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getVirtualMachineId() > 0L) : rule;
        assert (rule.getVirtualMachineName() != null) : rule;
    }
}

