/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import junit.framework.Assert;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.VlanIPRange;
import org.jclouds.cloudstack.features.BaseCloudStackRestClientExpectTest;
import org.jclouds.cloudstack.features.GlobalVlanClient;
import org.jclouds.cloudstack.options.CreateVlanIPRangeOptions;
import org.jclouds.cloudstack.options.ListVlanIPRangesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalVlanClientExpectTest")
public class GlobalVlanClientExpectTest
extends BaseCloudStackRestClientExpectTest<GlobalVlanClient> {
    public void testListVlanIpRangesWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listVlanIpRanges&apiKey=identity&signature=mS38BVfJjz1Y8bk0EdjJTeusJ0w%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listvlaniprangesresponse.json")).build());
        VlanIPRange range1 = VlanIPRange.builder().id(1L).forVirtualNetwork(true).zoneId(1L).vlan(127L).account("system").domainId(1L).domain("ROOT").gateway("10.27.27.254").netmask("255.255.255.0").startIP("10.27.27.50").endIP("10.27.27.100").networkId(200L).build();
        VlanIPRange range2 = VlanIPRange.builder().id(2L).forVirtualNetwork(false).zoneId(2L).vlan("untagged").account("system").domainId(1L).domain("ROOT").podId(2L).podName("Dev Pod 2").gateway("10.22.22.254").netmask("255.255.255.0").startIP("10.22.22.51").endIP("10.22.22.100").networkId(209L).build();
        Assert.assertEquals((Object)client.listVlanIPRanges(new ListVlanIPRangesOptions[0]), (Object)ImmutableSet.of((Object)range1, (Object)range2));
    }

    public void testListVlanIpRangesWhenResponseIs404() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listVlanIpRanges&apiKey=identity&signature=mS38BVfJjz1Y8bk0EdjJTeusJ0w%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Object)client.listVlanIPRanges(new ListVlanIPRangesOptions[0]), (Object)ImmutableSet.of());
    }

    public void testCreateVlanIpRangeWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createVlanIpRange&startip=10.22.22.51&endip=10.22.22.100&forvirtualnetwork=false&zoneid=2&vlan=untagged&account=system&domainid=1&podid=2&gateway=10.22.22.254&netmask=255.255.255.0&networkid=209&apiKey=identity&signature=XgDjPYAQNLMVCuSMGRA6QjV8mOY%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createvlaniprangeresponse.json")).build());
        VlanIPRange actual = client.createVlanIPRange("10.22.22.51", "10.22.22.100", new CreateVlanIPRangeOptions[]{new CreateVlanIPRangeOptions().forVirtualNetwork(false).zoneId(2L).vlan("untagged").accountInDomain("system", 1L).podId(2L).gateway("10.22.22.254").netmask("255.255.255.0").networkId(209L)});
        VlanIPRange expected = VlanIPRange.builder().id(2L).forVirtualNetwork(false).zoneId(2L).vlan("untagged").account("system").domainId(1L).domain("ROOT").podId(2L).podName("Dev Pod 2").gateway("10.22.22.254").netmask("255.255.255.0").startIP("10.22.22.51").endIP("10.22.22.100").networkId(209L).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void testDeleteVlanIpRangeWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteVlanIpRange&id=1&apiKey=identity&signature=tTBbpdCndgHXdR397fbbJaN1RZU%3D")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build()).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createvlaniprangeresponse.json")).build());
        client.deleteVlanIPRange(1L);
    }

    @Override
    protected GlobalVlanClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getVlanClient();
    }
}

