/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NATClientLiveTest")
public class NATClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(enabled=false)
    public void testListIPForwardingRules() throws Exception {
        Set response = this.client.getNATClient().listIPForwardingRules(new ListIPForwardingRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (IPForwardingRule rule : response) {
            IPForwardingRule newDetails = (IPForwardingRule)Iterables.getOnlyElement((Iterable)this.client.getNATClient().listIPForwardingRules(new ListIPForwardingRulesOptions[]{ListIPForwardingRulesOptions.Builder.id((long)rule.getId())}));
            Assert.assertEquals((long)rule.getId(), (long)newDetails.getId());
            this.checkRule(rule);
        }
    }

    protected void checkRule(IPForwardingRule rule) {
        Assert.assertEquals((long)rule.getId(), (long)this.client.getNATClient().getIPForwardingRule(rule.getId()).getId());
        assert (rule.getId() > 0L) : rule;
        assert (rule.getIPAddress() != null) : rule;
        assert (rule.getIPAddressId() > 0L) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getProtocol() != null) : rule;
        assert (rule.getEndPort() > 0) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getVirtualMachineId() > 0L) : rule;
        assert (rule.getVirtualMachineName() != null) : rule;
    }
}

