/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateExtraction;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.features.VirtualMachineClientLiveTest;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ExtractTemplateOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.ListVolumesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.options.RegisterTemplateOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="TemplateClientLiveTest")
public class TemplateClientLiveTest
extends BaseCloudStackClientLiveTest {
    private static final String IMPORT_VHD_URL = "http://www.frontiertown.co.uk/jclouds/empty.vhd";
    private VirtualMachine vmForCreation;
    private VirtualMachine vmForRegistration;
    private Template createdTemplate;
    private Template registeredTemplate;

    @Test
    public void testListTemplates() throws Exception {
        Set response = this.client.getTemplateClient().listTemplates();
        assert (null != response);
        long templateCount = response.size();
        Assert.assertTrue((templateCount >= 0L ? 1 : 0) != 0);
        for (Template template : response) {
            Template newDetails = (Template)Iterables.getOnlyElement((Iterable)this.client.getTemplateClient().listTemplates(ListTemplatesOptions.Builder.zoneId((long)template.getZoneId()).id(template.getId())));
            Logger.CONSOLE.info("Checking template: " + template, new Object[0]);
            Assert.assertEquals((Object)template, (Object)newDetails);
            Assert.assertEquals((Object)template, (Object)this.client.getTemplateClient().getTemplateInZone(template.getId(), template.getZoneId()));
            assert (template.getId() > 0L) : template;
            assert (template.getName() != null) : template;
            assert (template.getDisplayText() != null) : template;
            assert (template.getCreated() != null) : template;
            assert (template.getFormat() != null && template.getFormat() != Template.Format.UNRECOGNIZED) : template;
            assert (template.getOSType() != null) : template;
            assert (template.getOSTypeId() > 0L) : template;
            assert (template.getAccount() != null) : template;
            assert (template.getZone() != null) : template;
            assert (template.getZoneId() > 0L) : template;
            assert (template.getStatus() == null || template.getStatus().equals("Download Complete")) : template;
            assert (template.getType() != null && template.getType() != Template.Type.UNRECOGNIZED) : template;
            assert (template.getHypervisor() != null) : template;
            assert (template.getDomain() != null) : template;
            assert (template.getDomainId() > 0L) : template;
            assert (template.getSize() > 0L) : template;
        }
    }

    @Test(enabled=true)
    public void testCreateTemplate() throws Exception {
        Zone zone = (Zone)Iterables.getFirst((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[0]), null);
        Assert.assertNotNull((Object)zone);
        Iterable networks = this.client.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.zoneId((long)zone.getId()).isDefault(true)});
        networks = Iterables.filter((Iterable)networks, (Predicate)new Predicate<Network>(){

            public boolean apply(@Nullable Network network) {
                return network != null && network.getState().equals("Implemented");
            }
        });
        Assert.assertEquals((int)Iterables.size((Iterable)networks), (int)1);
        Network network = (Network)Iterables.getOnlyElement((Iterable)networks, null);
        Assert.assertNotNull((Object)network);
        Long templateId = this.imageId != null && !"".equals(this.imageId) ? new Long(this.imageId) : null;
        this.vmForCreation = VirtualMachineClientLiveTest.createVirtualMachineInNetwork(network, templateId, this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().stopVirtualMachine(this.vmForCreation.getId())), (String)this.vmForCreation.toString());
        Set volumes = this.client.getVolumeClient().listVolumes(new ListVolumesOptions[]{ListVolumesOptions.Builder.virtualMachineId((long)this.vmForCreation.getId())});
        Assert.assertEquals((int)volumes.size(), (int)1);
        Volume volume = (Volume)Iterables.getOnlyElement((Iterable)volumes);
        CreateTemplateOptions options = CreateTemplateOptions.Builder.volumeId((long)volume.getId());
        AsyncCreateResponse response = this.client.getTemplateClient().createTemplate(TemplateMetadata.builder().name(this.prefix + "-createTemplate").osTypeId(this.vmForCreation.getGuestOSId()).displayText("jclouds live testCreateTemplate").build(), new CreateTemplateOptions[]{options});
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)response.getJobId()), (String)this.vmForCreation.toString());
        this.createdTemplate = this.client.getTemplateClient().getTemplateInZone(response.getId(), this.vmForCreation.getZoneId());
        Assert.assertNotNull((Object)this.createdTemplate);
    }

    @Test(enabled=true, dependsOnMethods={"testRegisterTemplate"})
    public void testExtractTemplate() throws Exception {
        AsyncCreateResponse response = this.client.getTemplateClient().extractTemplate(this.registeredTemplate.getId(), ExtractMode.HTTP_DOWNLOAD, this.registeredTemplate.getZoneId(), new ExtractTemplateOptions[0]);
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)response.getJobId()), (String)this.registeredTemplate.toString());
        AsyncJob asyncJob = this.client.getAsyncJobClient().getAsyncJob(response.getJobId());
        TemplateExtraction extract = (TemplateExtraction)asyncJob.getResult();
        Assert.assertNotNull((Object)extract);
        String extractUrl = extract.getUrl();
        Assert.assertNotNull((Object)extractUrl);
        URI uri = new URI(URLDecoder.decode(extractUrl, "utf-8"));
        Assert.assertTrue((boolean)this.context.utils().http().exists(uri), (String)("does not exist: " + uri));
    }

    @Test(enabled=true)
    public void testRegisterTemplate() throws Exception {
        Zone zone = (Zone)Iterables.getFirst((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[0]), null);
        Assert.assertNotNull((Object)zone);
        Iterable networks = this.client.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.zoneId((long)zone.getId()).isDefault(true)});
        networks = Iterables.filter((Iterable)networks, (Predicate)new Predicate<Network>(){

            public boolean apply(@Nullable Network network) {
                return network != null && network.getState().equals("Implemented");
            }
        });
        Assert.assertEquals((int)Iterables.size((Iterable)networks), (int)1);
        Network network = (Network)Iterables.getOnlyElement((Iterable)networks, null);
        Assert.assertNotNull((Object)network);
        Set osTypes = this.client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[0]);
        OSType osType = (OSType)Iterables.getFirst((Iterable)osTypes, null);
        RegisterTemplateOptions options = RegisterTemplateOptions.Builder.bits((int)32).isExtractable(true);
        TemplateMetadata templateMetadata = TemplateMetadata.builder().name(this.prefix + "-registerTemplate").osTypeId(osType.getId()).displayText("jclouds live testRegisterTemplate").build();
        Set templates = this.client.getTemplateClient().registerTemplate(templateMetadata, "VHD", "XenServer", IMPORT_VHD_URL, zone.getId(), new RegisterTemplateOptions[]{options});
        this.registeredTemplate = (Template)Iterables.getOnlyElement((Iterable)templates, null);
        Assert.assertNotNull((Object)this.registeredTemplate);
        final long zoneId = zone.getId();
        Predicate<Template> templateReadyPredicate = new Predicate<Template>(){

            public boolean apply(@Nullable Template template) {
                if (template == null) {
                    return false;
                }
                Template t2 = TemplateClientLiveTest.this.client.getTemplateClient().getTemplateInZone(template.getId(), zoneId);
                Logger.CONSOLE.info("%s", new Object[]{t2.getStatus()});
                return "Download Complete".equals(t2.getStatus());
            }
        };
        Assert.assertTrue((boolean)new RetryablePredicate((Predicate)templateReadyPredicate, 60000L).apply((Object)this.registeredTemplate));
        this.vmForRegistration = VirtualMachineClientLiveTest.createVirtualMachineInNetwork(network, this.registeredTemplate.getId(), this.client, (RetryablePredicate<Long>)this.jobComplete, (RetryablePredicate<VirtualMachine>)this.virtualMachineRunning);
        Assert.assertNotNull((Object)this.vmForRegistration);
    }

    @Override
    @AfterGroups(groups={"live"})
    protected void tearDown() {
        AsyncCreateResponse deleteJob;
        if (this.vmForCreation != null) {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().stopVirtualMachine(this.vmForCreation.getId())), (String)this.vmForCreation.toString());
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vmForCreation.getId())), (String)this.vmForCreation.toString());
            Assert.assertTrue((boolean)this.virtualMachineDestroyed.apply((Object)this.vmForCreation));
        }
        if (this.vmForRegistration != null) {
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().stopVirtualMachine(this.vmForRegistration.getId())), (String)this.vmForRegistration.toString());
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)this.client.getVirtualMachineClient().destroyVirtualMachine(this.vmForRegistration.getId())), (String)this.vmForRegistration.toString());
            assert (this.virtualMachineDestroyed.apply((Object)this.vmForRegistration));
        }
        if (this.createdTemplate != null) {
            deleteJob = this.client.getTemplateClient().deleteTemplate(this.createdTemplate.getId(), new DeleteTemplateOptions[0]);
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)deleteJob.getJobId()));
        }
        if (this.registeredTemplate != null) {
            deleteJob = this.client.getTemplateClient().deleteTemplate(this.registeredTemplate.getId(), new DeleteTemplateOptions[0]);
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)deleteJob.getJobId()));
        }
        super.tearDown();
    }
}

